/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.deps.com.alibaba.fastjson2.support;

import com.alibaba.arthas.deps.com.alibaba.fastjson2.JSONException;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.reader.ObjectReaders;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.writer.ObjectWriters;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public class LambdaMiscCodec {
    static volatile boolean hppcError;
    static volatile Throwable errorLast;

    public static ObjectWriter getObjectWriter(Type objectType, Class objectClass) {
        String className;
        if (hppcError) {
            return null;
        }
        switch (className = objectClass.getName()) {
            case "gnu.trove.set.hash.TByteHashSet": 
            case "gnu.trove.stack.array.TByteArrayStack": 
            case "gnu.trove.list.array.TByteArrayList": 
            case "com.carrotsearch.hppc.ByteArrayList": {
                try {
                    return ObjectWriters.ofToByteArray(LambdaMiscCodec.createFunction(objectClass.getMethod("toArray", new Class[0])));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new JSONException("illegal state", e);
                }
            }
            case "gnu.trove.set.hash.TShortHashSet": 
            case "gnu.trove.list.array.TShortArrayList": 
            case "com.carrotsearch.hppc.ShortArrayList": {
                try {
                    return ObjectWriters.ofToShortArray(LambdaMiscCodec.createFunction(objectClass.getMethod("toArray", new Class[0])));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new JSONException("illegal state", e);
                }
            }
            case "gnu.trove.list.array.TIntArrayList": 
            case "gnu.trove.set.hash.TIntHashSet": 
            case "com.carrotsearch.hppc.IntArrayList": 
            case "com.carrotsearch.hppc.IntHashSet": {
                try {
                    return ObjectWriters.ofToIntArray(LambdaMiscCodec.createFunction(objectClass.getMethod("toArray", new Class[0])));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new JSONException("illegal state", e);
                }
            }
            case "gnu.trove.list.array.TLongArrayList": 
            case "gnu.trove.set.hash.TLongHashSet": 
            case "com.carrotsearch.hppc.LongArrayList": 
            case "com.carrotsearch.hppc.LongHashSet": {
                try {
                    return ObjectWriters.ofToLongArray(LambdaMiscCodec.createFunction(objectClass.getMethod("toArray", new Class[0])));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new JSONException("illegal state", e);
                }
            }
            case "gnu.trove.list.array.TCharArrayList": 
            case "com.carrotsearch.hppc.CharArrayList": 
            case "com.carrotsearch.hppc.CharHashSet": {
                try {
                    return ObjectWriters.ofToCharArray(LambdaMiscCodec.createFunction(objectClass.getMethod("toArray", new Class[0])));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new JSONException("illegal state", e);
                }
            }
            case "gnu.trove.list.array.TFloatArrayList": 
            case "com.carrotsearch.hppc.FloatArrayList": {
                try {
                    return ObjectWriters.ofToFloatArray(LambdaMiscCodec.createFunction(objectClass.getMethod("toArray", new Class[0])));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new JSONException("illegal state", e);
                }
            }
            case "gnu.trove.list.array.TDoubleArrayList": 
            case "com.carrotsearch.hppc.DoubleArrayList": {
                try {
                    return ObjectWriters.ofToDoubleArray(LambdaMiscCodec.createFunction(objectClass.getMethod("toArray", new Class[0])));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new JSONException("illegal state", e);
                }
            }
            case "com.carrotsearch.hppc.BitSet": {
                MethodHandles.Lookup lookup = JDKUtils.trustedLookup(objectClass);
                try {
                    ToLongFunction functionSize = LambdaMiscCodec.createToLongFunction(objectClass.getMethod("size", new Class[0]));
                    MethodHandle getHandler = lookup.findVirtual(objectClass, "get", MethodType.methodType(Boolean.TYPE, Integer.TYPE));
                    CallSite getCallSite = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(BiFunction.class), MethodType.methodType(Object.class, Object.class, Object.class), getHandler, MethodType.methodType(Boolean.class, objectClass, Integer.class));
                    BiFunction functionGet = getCallSite.getTarget().invokeExact();
                    return ObjectWriters.ofToBooleanArray(functionSize, (BiFunction<Object, Integer, Boolean>)functionGet);
                }
                catch (Throwable ignored) {
                    hppcError = true;
                    break;
                }
            }
            case "org.bson.types.Decimal128": {
                try {
                    return ObjectWriters.ofToBigDecimal(LambdaMiscCodec.createFunction(objectClass.getMethod("bigDecimalValue", new Class[0])));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new JSONException("illegal state", e);
                }
            }
        }
        return null;
    }

    public static ObjectReader getObjectReader(Class objectClass) {
        String className;
        if (hppcError) {
            return null;
        }
        switch (className = objectClass.getName()) {
            case "com.carrotsearch.hppc.ByteArrayList": {
                try {
                    return ObjectReaders.fromByteArray(LambdaMiscCodec.createFunction(objectClass.getMethod("from", byte[].class)));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new JSONException("illegal state", e);
                }
            }
            case "com.carrotsearch.hppc.ShortArrayList": {
                try {
                    return ObjectReaders.fromShortArray(LambdaMiscCodec.createFunction(objectClass.getMethod("from", short[].class)));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new JSONException("illegal state", e);
                }
            }
            case "com.carrotsearch.hppc.IntArrayList": 
            case "com.carrotsearch.hppc.IntHashSet": {
                try {
                    return ObjectReaders.fromIntArray(LambdaMiscCodec.createFunction(objectClass.getMethod("from", int[].class)));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new JSONException("illegal state", e);
                }
            }
            case "com.carrotsearch.hppc.LongArrayList": 
            case "com.carrotsearch.hppc.LongHashSet": {
                try {
                    return ObjectReaders.fromLongArray(LambdaMiscCodec.createFunction(objectClass.getMethod("from", long[].class)));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new JSONException("illegal state", e);
                }
            }
            case "com.carrotsearch.hppc.CharArrayList": 
            case "com.carrotsearch.hppc.CharHashSet": {
                try {
                    return ObjectReaders.fromCharArray(LambdaMiscCodec.createFunction(objectClass.getMethod("from", char[].class)));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new JSONException("illegal state", e);
                }
            }
            case "com.carrotsearch.hppc.FloatArrayList": {
                try {
                    return ObjectReaders.fromFloatArray(LambdaMiscCodec.createFunction(objectClass.getMethod("from", float[].class)));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new JSONException("illegal state", e);
                }
            }
            case "com.carrotsearch.hppc.DoubleArrayList": {
                try {
                    return ObjectReaders.fromDoubleArray(LambdaMiscCodec.createFunction(objectClass.getMethod("from", double[].class)));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new JSONException("illegal state", e);
                }
            }
            case "gnu.trove.set.hash.TByteHashSet": 
            case "gnu.trove.stack.array.TByteArrayStack": 
            case "gnu.trove.list.array.TByteArrayList": {
                try {
                    return ObjectReaders.fromByteArray(LambdaMiscCodec.createFunction(objectClass.getConstructor(byte[].class)));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new JSONException("illegal state", e);
                }
            }
            case "gnu.trove.list.array.TCharArrayList": {
                try {
                    return ObjectReaders.fromCharArray(LambdaMiscCodec.createFunction(objectClass.getConstructor(char[].class)));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new JSONException("illegal state", e);
                }
            }
            case "gnu.trove.set.hash.TShortHashSet": 
            case "gnu.trove.list.array.TShortArrayList": {
                try {
                    return ObjectReaders.fromShortArray(LambdaMiscCodec.createFunction(objectClass.getConstructor(short[].class)));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new JSONException("illegal state", e);
                }
            }
            case "gnu.trove.set.hash.TIntHashSet": 
            case "gnu.trove.list.array.TIntArrayList": {
                try {
                    return ObjectReaders.fromIntArray(LambdaMiscCodec.createFunction(objectClass.getConstructor(int[].class)));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new JSONException("illegal state", e);
                }
            }
            case "gnu.trove.set.hash.TLongHashSet": 
            case "gnu.trove.list.array.TLongArrayList": {
                try {
                    return ObjectReaders.fromLongArray(LambdaMiscCodec.createFunction(objectClass.getConstructor(long[].class)));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new JSONException("illegal state", e);
                }
            }
            case "gnu.trove.list.array.TFloatArrayList": {
                try {
                    return ObjectReaders.fromFloatArray(LambdaMiscCodec.createFunction(objectClass.getConstructor(float[].class)));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new JSONException("illegal state", e);
                }
            }
            case "gnu.trove.list.array.TDoubleArrayList": {
                try {
                    return ObjectReaders.fromDoubleArray(LambdaMiscCodec.createFunction(objectClass.getConstructor(double[].class)));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new JSONException("illegal state", e);
                }
            }
            case "org.bson.types.Decimal128": {
                try {
                    return ObjectReaders.fromBigDecimal(LambdaMiscCodec.createFunction(objectClass.getConstructor(BigDecimal.class)));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new JSONException("illegal state", e);
                }
            }
        }
        return null;
    }

    public static LongFunction createLongFunction(Constructor constructor) {
        try {
            Class objectClass = constructor.getDeclaringClass();
            MethodHandles.Lookup lookup = JDKUtils.trustedLookup(objectClass);
            MethodHandle methodHandle = lookup.findConstructor(objectClass, TypeUtils.METHOD_TYPE_VOID_LONG);
            MethodType invokedType = MethodType.methodType(objectClass, Long.TYPE);
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "apply", TypeUtils.METHOD_TYPE_LONG_FUNCTION, TypeUtils.METHOD_TYPE_OBJECT_LONG, methodHandle, invokedType);
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable ignored) {
            errorLast = ignored;
            return new ReflectLongFunction(constructor);
        }
    }

    public static ToIntFunction createToIntFunction(Method method) {
        Class<?> objectClass = method.getDeclaringClass();
        try {
            MethodHandles.Lookup lookup = JDKUtils.trustedLookup(objectClass);
            MethodType methodType = MethodType.methodType(Integer.TYPE);
            MethodHandle methodHandle = lookup.findVirtual(objectClass, method.getName(), methodType);
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "applyAsInt", TypeUtils.METHOD_TYPE_TO_INT_FUNCTION, TypeUtils.METHOD_TYPE_INT_OBJECT, methodHandle, MethodType.methodType(Integer.TYPE, objectClass));
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable ignored) {
            errorLast = ignored;
            return new ReflectToIntFunction(method);
        }
    }

    public static ToLongFunction createToLongFunction(Method method) {
        Class<?> objectClass = method.getDeclaringClass();
        try {
            MethodHandles.Lookup lookup = JDKUtils.trustedLookup(objectClass);
            MethodType methodType = MethodType.methodType(Long.TYPE);
            MethodHandle methodHandle = lookup.findVirtual(objectClass, method.getName(), methodType);
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "applyAsLong", TypeUtils.METHOD_TYPE_TO_LONG_FUNCTION, TypeUtils.METHOD_TYPE_LONG_OBJECT, methodHandle, MethodType.methodType(Long.TYPE, objectClass));
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable ignored) {
            errorLast = ignored;
            return new ReflectToLongFunction(method);
        }
    }

    public static Function createFunction(Constructor constructor) {
        try {
            Class declaringClass = constructor.getDeclaringClass();
            MethodHandles.Lookup lookup = JDKUtils.trustedLookup(declaringClass);
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            Class<?> param0 = parameterTypes[0];
            MethodHandle methodHandle = lookup.findConstructor(declaringClass, MethodType.methodType(Void.TYPE, param0));
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "apply", TypeUtils.METHOD_TYPE_FUNCTION, TypeUtils.METHOD_TYPE_OBJECT_OBJECT, methodHandle, MethodType.methodType(declaringClass, param0));
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable ignored) {
            errorLast = ignored;
            return new ConstructorFunction(constructor);
        }
    }

    public static Supplier createSupplier(Constructor constructor) {
        try {
            Class declaringClass = constructor.getDeclaringClass();
            MethodHandles.Lookup lookup = JDKUtils.trustedLookup(declaringClass);
            MethodHandle methodHandle = lookup.findConstructor(declaringClass, MethodType.methodType(Void.TYPE));
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "get", TypeUtils.METHOD_TYPE_SUPPLIER, TypeUtils.METHOD_TYPE_OBJECT, methodHandle, MethodType.methodType(declaringClass));
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable ignored) {
            errorLast = ignored;
            return new ConstructorSupplier(constructor);
        }
    }

    public static Supplier createSupplier(Method method) {
        try {
            Class<?> declaringClass = method.getDeclaringClass();
            Class<?> objectClass = method.getReturnType();
            MethodHandles.Lookup lookup = JDKUtils.trustedLookup(declaringClass);
            MethodHandle methodHandle = lookup.findStatic(declaringClass, method.getName(), MethodType.methodType(objectClass));
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "get", TypeUtils.METHOD_TYPE_SUPPLIER, TypeUtils.METHOD_TYPE_OBJECT, methodHandle, MethodType.methodType(objectClass));
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable ignored) {
            errorLast = ignored;
            return new ReflectSupplier(method);
        }
    }

    public static BiFunction createBiFunction(Method method) {
        try {
            MethodType methodType;
            MethodHandle methodHandle;
            Class<?> declaringClass = method.getDeclaringClass();
            Class<?> objectClass = method.getReturnType();
            MethodHandles.Lookup lookup = JDKUtils.trustedLookup(declaringClass);
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class<?> param0 = parameterTypes[0];
            if (Modifier.isStatic(method.getModifiers())) {
                Class<?> param1 = parameterTypes[1];
                methodHandle = lookup.findStatic(declaringClass, method.getName(), MethodType.methodType(objectClass, param0, param1));
                methodType = MethodType.methodType(objectClass, param0, param1);
            } else {
                methodHandle = lookup.findVirtual(declaringClass, method.getName(), MethodType.methodType(objectClass, param0));
                methodType = MethodType.methodType(objectClass, declaringClass, param0);
            }
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "apply", TypeUtils.METHOD_TYPE_BI_FUNCTION, TypeUtils.METHOD_TYPE_OBJECT_OBJECT_OBJECT, methodHandle, methodType);
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable ignored) {
            errorLast = ignored;
            return new ReflectBiFunction(method);
        }
    }

    public static BiFunction createBiFunction(Constructor constructor) {
        try {
            Class declaringClass = constructor.getDeclaringClass();
            MethodHandles.Lookup lookup = JDKUtils.trustedLookup(declaringClass);
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            Class<?> param0 = parameterTypes[0];
            Class<?> param1 = parameterTypes[1];
            MethodHandle methodHandle = lookup.findConstructor(declaringClass, MethodType.methodType(Void.TYPE, param0, param1));
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "apply", TypeUtils.METHOD_TYPE_BI_FUNCTION, TypeUtils.METHOD_TYPE_OBJECT_OBJECT_OBJECT, methodHandle, MethodType.methodType(declaringClass, param0, param1));
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable ignored) {
            errorLast = ignored;
            return new ConstructorBiFunction(constructor);
        }
    }

    public static Function createFunction(Method method) {
        Class<?> paramClass;
        Class<?> declaringClass = method.getDeclaringClass();
        int modifiers = method.getModifiers();
        Class<?>[] parameterTypes = method.getParameterTypes();
        boolean isStatic = Modifier.isStatic(modifiers);
        Class<?> objectClass = method.getReturnType();
        if (parameterTypes.length == 1 && isStatic) {
            paramClass = parameterTypes[0];
        } else if (parameterTypes.length == 0 && !isStatic) {
            paramClass = declaringClass;
        } else {
            throw new JSONException("not support parameters " + method);
        }
        try {
            MethodHandles.Lookup lookup = JDKUtils.trustedLookup(declaringClass);
            MethodHandle methodHandle = isStatic ? lookup.findStatic(declaringClass, method.getName(), MethodType.methodType(objectClass, paramClass)) : lookup.findVirtual(declaringClass, method.getName(), MethodType.methodType(objectClass));
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "apply", TypeUtils.METHOD_TYPE_FUNCTION, TypeUtils.METHOD_TYPE_OBJECT_OBJECT, methodHandle, MethodType.methodType(objectClass, paramClass));
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable ignored) {
            errorLast = ignored;
            if (!Modifier.isStatic(method.getModifiers())) {
                return new GetterFunction(method);
            }
            return new FactoryFunction(method);
        }
    }

    public static ObjIntConsumer createObjIntConsumer(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        try {
            MethodHandles.Lookup lookup = JDKUtils.trustedLookup(declaringClass);
            MethodType methodType = MethodType.methodType(Void.TYPE, Integer.TYPE);
            MethodHandle methodHandle = lookup.findVirtual(declaringClass, method.getName(), methodType);
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "accept", TypeUtils.METHOD_TYPE_OBJECT_INT_CONSUMER, TypeUtils.METHOD_TYPE_VOID_OBJECT_INT, methodHandle, MethodType.methodType(Void.TYPE, declaringClass, Integer.TYPE));
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable ignored) {
            errorLast = ignored;
            return new ReflectObjIntConsumer(method);
        }
    }

    static final class ReflectToLongFunction
    implements ToLongFunction {
        final Method method;

        public ReflectToLongFunction(Method method) {
            this.method = method;
        }

        public long applyAsLong(Object object) {
            try {
                return (Long)this.method.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw new JSONException("applyAsLong error", e);
            }
        }
    }

    static final class ReflectToIntFunction
    implements ToIntFunction {
        final Method method;

        public ReflectToIntFunction(Method method) {
            this.method = method;
        }

        public int applyAsInt(Object object) {
            try {
                return (Integer)this.method.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw new JSONException("applyAsInt error", e);
            }
        }
    }

    static final class ReflectLongFunction
    implements LongFunction {
        final Constructor constructor;

        public ReflectLongFunction(Constructor constructor) {
            this.constructor = constructor;
        }

        public Object apply(long value) {
            try {
                return this.constructor.newInstance(value);
            }
            catch (Exception e) {
                throw new JSONException("createInstance error", e);
            }
        }
    }

    static final class GetterFunction
    implements Function {
        final Method method;

        GetterFunction(Method method) {
            this.method = method;
        }

        public Object apply(Object arg) {
            try {
                return this.method.invoke(arg, new Object[0]);
            }
            catch (Exception e) {
                throw new JSONException("createInstance error", e);
            }
        }
    }

    static final class FactoryFunction
    implements Function {
        final Method method;

        FactoryFunction(Method method) {
            this.method = method;
        }

        public Object apply(Object arg) {
            try {
                return this.method.invoke(null, arg);
            }
            catch (Exception e) {
                throw new JSONException("createInstance error", e);
            }
        }
    }

    static final class ReflectObjIntConsumer
    implements ObjIntConsumer {
        final Method method;

        public ReflectObjIntConsumer(Method method) {
            this.method = method;
        }

        public void accept(Object object, int value) {
            try {
                this.method.invoke(object, value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new JSONException("invoke error", e);
            }
        }
    }

    static final class ReflectSupplier
    implements Supplier {
        final Method method;

        ReflectSupplier(Method method) {
            this.method = method;
        }

        public Object get() {
            try {
                return this.method.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new JSONException("invoke error", e);
            }
        }
    }

    static final class ReflectBiFunction
    implements BiFunction {
        final Method method;

        ReflectBiFunction(Method method) {
            this.method = method;
        }

        public Object apply(Object arg0, Object arg1) {
            try {
                if (Modifier.isStatic(this.method.getModifiers())) {
                    return this.method.invoke(null, arg0, arg1);
                }
                return this.method.invoke(arg0, arg1);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new JSONException("invoke error", e);
            }
        }
    }

    static final class ConstructorBiFunction
    implements BiFunction {
        final Constructor constructor;

        ConstructorBiFunction(Constructor constructor) {
            this.constructor = constructor;
        }

        public Object apply(Object arg0, Object arg1) {
            try {
                return this.constructor.newInstance(arg0, arg1);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new JSONException("invoke error", e);
            }
        }
    }

    static final class ConstructorFunction
    implements Function {
        final Constructor constructor;

        ConstructorFunction(Constructor constructor) {
            this.constructor = constructor;
        }

        public Object apply(Object arg0) {
            try {
                return this.constructor.newInstance(arg0);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new JSONException("invoke error", e);
            }
        }
    }

    static final class ConstructorSupplier
    implements Supplier {
        final Constructor constructor;

        ConstructorSupplier(Constructor constructor) {
            this.constructor = constructor;
        }

        public Object get() {
            try {
                return this.constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new JSONException("invoke error", e);
            }
        }
    }
}

