/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.client;

import com.alibaba.arthas.deps.io.netty.buffer.Unpooled;
import com.alibaba.arthas.deps.io.netty.channel.Channel;
import com.alibaba.arthas.deps.io.netty.channel.ChannelHandlerContext;
import com.alibaba.arthas.deps.io.netty.channel.ChannelInboundHandlerAdapter;
import com.alibaba.arthas.deps.io.netty.util.ReferenceCountUtil;
import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.alibaba.arthas.tunnel.client.ChannelUtils;

public final class RelayHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(RelayHandler.class);
    private final Channel relayChannel;

    public RelayHandler(Channel relayChannel) {
        this.relayChannel = relayChannel;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        ctx.writeAndFlush(Unpooled.EMPTY_BUFFER);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.relayChannel.isActive()) {
            this.relayChannel.writeAndFlush(msg);
        } else {
            ReferenceCountUtil.release(msg);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.relayChannel.isActive()) {
            ChannelUtils.closeOnFlush(this.relayChannel);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("RelayHandler error", cause);
        try {
            if (this.relayChannel.isActive()) {
                this.relayChannel.close();
            }
        }
        finally {
            ctx.close();
        }
    }
}

