/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm;

import com.alibaba.bytekit.asm.meta.ClassMeta;
import com.alibaba.bytekit.utils.ClassLoaderUtils;
import com.alibaba.deps.org.objectweb.asm.ClassReader;
import com.alibaba.deps.org.objectweb.asm.ClassWriter;

public class ClassMetaClassWriter
extends ClassWriter {
    private ClassLoader classLoader;

    public ClassMetaClassWriter(int flags, ClassLoader loader) {
        this(null, flags, loader);
    }

    public ClassMetaClassWriter(ClassReader classReader, int flags, ClassLoader loader) {
        super(classReader, flags);
        this.classLoader = ClassLoaderUtils.wrap(loader);
    }

    @Override
    protected String getCommonSuperClass(String type1, String type2) {
        ClassMeta classMeta2;
        byte[] type1Bytes = ClassLoaderUtils.readBytecodeByName(this.classLoader, type1);
        if (type1Bytes == null) {
            return super.getCommonSuperClass(type1, type2);
        }
        byte[] type2Bytes = ClassLoaderUtils.readBytecodeByName(this.classLoader, type2);
        if (type2Bytes == null) {
            return super.getCommonSuperClass(type1, type2);
        }
        ClassMeta classMeta1 = ClassMeta.fromByteCode(type1Bytes, this.classLoader);
        if (classMeta1.isAssignableFrom(classMeta2 = ClassMeta.fromByteCode(type2Bytes, this.classLoader))) {
            return type1;
        }
        if (classMeta2.isAssignableFrom(classMeta1)) {
            return type2;
        }
        if (classMeta1.isInterface() || classMeta2.isInterface()) {
            return "java/lang/Object";
        }
        do {
            if ((classMeta1 = classMeta1.getSuperclass()) != null) continue;
            return this.getCommonSuperClass(type1, type2);
        } while (!classMeta1.isAssignableFrom(classMeta2));
        return classMeta1.getInternalClassName();
    }

    @Override
    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

