/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.meta;

import com.alibaba.bytekit.asm.meta.ClassMeta;
import com.alibaba.bytekit.utils.ClassLoaderUtils;
import java.util.concurrent.ConcurrentHashMap;

public class ClassMetaCache {
    private static final ClassMeta NO_EXIST_CLASSMETA = new ClassMeta();
    private final ConcurrentHashMap<String, ClassMeta> classMetaMap = new ConcurrentHashMap();
    private ClassLoader classLoader;

    public ClassMetaCache(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void addClassMeta(String internalClassName, ClassMeta meta) {
        this.classMetaMap.put(internalClassName, meta);
    }

    public ClassMeta findClassMeta(String internalClassName) {
        ClassMeta classMeta = this.classMetaMap.get(internalClassName);
        if (classMeta == NO_EXIST_CLASSMETA) {
            return null;
        }
        if (classMeta == null) {
            byte[] bytes = ClassLoaderUtils.readBytecodeByName(this.classLoader, internalClassName);
            if (bytes != null) {
                classMeta = ClassMeta.fromByteCode(bytes, this.classLoader);
                ClassMeta existed = this.classMetaMap.putIfAbsent(internalClassName, classMeta);
                if (existed != null) {
                    classMeta = existed;
                }
            } else {
                this.classMetaMap.put(internalClassName, NO_EXIST_CLASSMETA);
                return null;
            }
        }
        return classMeta;
    }

    public ClassMeta findAndTryLoadClassMeta(String internalClassName, byte[] classfileBuffer, ClassLoader classLoader) {
        ClassMeta existed;
        ClassMeta classMeta = null;
        if (internalClassName != null) {
            classMeta = this.classMetaMap.get(internalClassName);
        }
        if ((classMeta == null || classMeta == NO_EXIST_CLASSMETA) && (existed = this.classMetaMap.putIfAbsent((classMeta = ClassMeta.fromByteCode(classfileBuffer, classLoader)).getInternalClassName(), classMeta)) != null) {
            classMeta = existed;
        }
        return classMeta;
    }
}

