/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.advisor;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class TransformerManager {
    private Instrumentation instrumentation;
    private List<ClassFileTransformer> watchTransformers = new CopyOnWriteArrayList<ClassFileTransformer>();
    private List<ClassFileTransformer> traceTransformers = new CopyOnWriteArrayList<ClassFileTransformer>();
    private List<ClassFileTransformer> reTransformers = new CopyOnWriteArrayList<ClassFileTransformer>();
    private ClassFileTransformer classFileTransformer;

    public TransformerManager(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
        this.classFileTransformer = new ClassFileTransformer(){

            @Override
            public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                byte[] transformResult;
                for (ClassFileTransformer classFileTransformer : TransformerManager.this.reTransformers) {
                    transformResult = classFileTransformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
                    if (transformResult == null) continue;
                    classfileBuffer = transformResult;
                }
                for (ClassFileTransformer classFileTransformer : TransformerManager.this.watchTransformers) {
                    transformResult = classFileTransformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
                    if (transformResult == null) continue;
                    classfileBuffer = transformResult;
                }
                for (ClassFileTransformer classFileTransformer : TransformerManager.this.traceTransformers) {
                    transformResult = classFileTransformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
                    if (transformResult == null) continue;
                    classfileBuffer = transformResult;
                }
                return classfileBuffer;
            }
        };
        instrumentation.addTransformer(this.classFileTransformer, true);
    }

    public void addTransformer(ClassFileTransformer transformer, boolean isTracing) {
        if (isTracing) {
            this.traceTransformers.add(transformer);
        } else {
            this.watchTransformers.add(transformer);
        }
    }

    public void addRetransformer(ClassFileTransformer transformer) {
        this.reTransformers.add(transformer);
    }

    public void removeTransformer(ClassFileTransformer transformer) {
        this.reTransformers.remove(transformer);
        this.watchTransformers.remove(transformer);
        this.traceTransformers.remove(transformer);
    }

    public void destroy() {
        this.reTransformers.clear();
        this.watchTransformers.clear();
        this.traceTransformers.clear();
        this.instrumentation.removeTransformer(this.classFileTransformer);
    }
}

