/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.basic1000;

import com.taobao.arthas.core.command.model.JFRModel;
import com.taobao.arthas.core.server.ArthasBootstrap;
import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import jdk.jfr.Configuration;
import jdk.jfr.Recording;

@Name(value="jfr")
@Summary(value="Java Flight Recorder Command")
@Description(value="\nEXAMPLES:\n  jfr start  # start a new JFR recording\n  jfr start -n myRecording --duration 60s -f /tmp/myRecording.jfr \n  jfr status                   # list all recordings\n  jfr status -r 1              # list recording id = 1 \n  jfr status --state running   # list recordings state = running\n  jfr stop -r 1               # stop a JFR recording to default file\n  jfr stop -r 1 -f /tmp/myRecording.jfr\n  jfr dump -r 1               # copy contents of a JFR recording to default file\n  jfr dump -r 1 -f /tmp/myRecording.jfr\n\nWIKI:\n  https://arthas.aliyun.com/doc/jfr")
public class JFRCommand
extends AnnotatedCommand {
    private String cmd;
    private String name;
    private String settings;
    private Boolean dumpOnExit;
    private String delay;
    private String duration;
    private String filename;
    private String maxAge;
    private String maxSize;
    private Long recording;
    private String state;
    private JFRModel result = new JFRModel();
    private static Map<Long, Recording> recordings = new ConcurrentHashMap<Long, Recording>();

    @Argument(index=0, argName="cmd", required=true)
    @Description(value="command name (start status stop dump)")
    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    @Option(shortName="n", longName="name")
    @Description(value="Name that can be used to identify recording, e.g. \"My Recording\"")
    public void setName(String name) {
        this.name = name;
    }

    @Option(shortName="s", longName="settings")
    @Description(value="Settings file(s), e.g. profile or default. See JRE_HOME/lib/jfr (STRING , default)")
    public void setSettings(String settings) {
        this.settings = settings;
    }

    @Option(longName="dumponexit")
    @Description(value="Dump running recording when JVM shuts down (BOOLEAN, false)")
    public void setDumpOnExit(Boolean dumpOnExit) {
        this.dumpOnExit = dumpOnExit;
    }

    @Option(shortName="d", longName="delay")
    @Description(value="Delay recording start with (s)econds, (m)inutes), (h)ours), or (d)ays, e.g. 5h. (NANOTIME, 0)")
    public void setDelay(String delay) {
        this.delay = delay;
    }

    @Option(longName="duration")
    @Description(value="Duration of recording in (s)econds, (m)inutes, (h)ours, or (d)ays, e.g. 300s. (NANOTIME, 0)")
    public void setDuration(String duration) {
        this.duration = duration;
    }

    @Option(shortName="f", longName="filename")
    @Description(value="Resulting recording filename, e.g. /tmp/MyRecording.jfr.")
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Option(longName="maxage")
    @Description(value="Maximum time to keep recorded data (on disk) in (s)econds, (m)inutes, (h)ours, or (d)ays, e.g. 60m, or default for no limit (NANOTIME, 0)")
    public void setMaxAge(String maxAge) {
        this.maxAge = maxAge;
    }

    @Option(longName="maxsize")
    @Description(value="Maximum amount of bytes to keep (on disk) in (k)B, (M)B or (G)B, e.g. 500M, 0 for no limit (MEMORY SIZE, 250MB)")
    public void setMaxSize(String maxSize) {
        this.maxSize = maxSize;
    }

    @Option(shortName="r", longName="recording")
    @Description(value="Recording number, or omit to see all recordings (LONG, -1)")
    public void setRecording(Long recording) {
        this.recording = recording;
    }

    @Option(longName="state")
    @Description(value="Query recordings by sate (new, delay, running, stopped, closed)")
    public void setState(String state) {
        this.state = state;
    }

    public String getCmd() {
        return this.cmd;
    }

    public String getName() {
        return this.name;
    }

    public String getSettings() {
        return this.settings;
    }

    public Boolean isDumpOnExit() {
        return this.dumpOnExit;
    }

    public String getDelay() {
        return this.delay;
    }

    public String getDuration() {
        return this.duration;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getMaxAge() {
        return this.maxAge;
    }

    public String getMaxSize() {
        return this.maxSize;
    }

    public Long getRecording() {
        return this.recording;
    }

    public String getState() {
        return this.state;
    }

    @Override
    public void process(CommandProcess process) {
        if ("start".equals(this.cmd)) {
            Configuration c = null;
            try {
                if (this.getSettings() == null) {
                    this.setSettings("default");
                }
                c = Configuration.getConfiguration(this.settings);
            }
            catch (Throwable e) {
                process.end(-1, "Could not start recording, not able to read settings");
            }
            Recording r = new Recording(c);
            if (this.getFilename() != null) {
                try {
                    r.setDestination(Paths.get(this.getFilename(), new String[0]));
                }
                catch (IOException e) {
                    r.close();
                    process.end(-1, "Could not start recording, not able to write to file " + this.getFilename() + e.getMessage());
                }
            }
            if (this.getMaxSize() != null) {
                try {
                    r.setMaxSize(this.parseSize(this.getMaxSize()));
                }
                catch (Exception e) {
                    process.end(-1, e.getMessage());
                }
            }
            if (this.getMaxAge() != null) {
                try {
                    r.setMaxAge(Duration.ofNanos(this.parseTimespan(this.getMaxAge())));
                }
                catch (Exception e) {
                    process.end(-1, e.getMessage());
                }
            }
            if (this.isDumpOnExit().booleanValue()) {
                r.setDumpOnExit(this.isDumpOnExit());
            }
            if (this.getDuration() != null) {
                try {
                    r.setDuration(Duration.ofNanos(this.parseTimespan(this.getDuration())));
                }
                catch (Exception e) {
                    process.end(-1, e.getMessage());
                }
            }
            if (this.getName() == null) {
                r.setName("Recording-" + r.getId());
            } else {
                r.setName(this.getName());
            }
            long id = r.getId();
            recordings.put(id, r);
            if (this.getDelay() != null) {
                try {
                    r.scheduleStart(Duration.ofNanos(this.parseTimespan(this.getDelay())));
                }
                catch (Exception e) {
                    process.end(-1, e.getMessage());
                }
                this.result.setJfrOutput("Recording " + r.getId() + " scheduled to start in " + this.getDelay());
            } else {
                r.start();
                this.result.setJfrOutput("Started recording " + r.getId() + ".");
            }
            if (this.duration == null && this.maxAge == null && this.maxSize == null) {
                this.result.setJfrOutput(" No limit specified, using maxsize=250MB as default.");
                r.setMaxSize(0xFA00000L);
            }
            if (this.filename != null && this.duration != null) {
                this.result.setJfrOutput(" The result will be written to:\n" + this.filename);
            }
        } else if ("status".equals(this.cmd)) {
            if (this.getRecording() != null) {
                Recording r = recordings.get(this.getRecording());
                if (r == null) {
                    process.end(-1, "recording not exit");
                }
                this.printRecording(r);
            } else {
                List<Recording> recordingList = this.state != null ? this.findRecordingByState(this.state) : new ArrayList<Recording>(recordings.values());
                if (recordingList.isEmpty()) {
                    process.end(-1, "No available recordings.\n Use jfr start to start a recording.\n");
                } else {
                    for (Recording recording : recordingList) {
                        this.printRecording(recording);
                    }
                }
            }
        } else if ("dump".equals(this.cmd)) {
            if (recordings.isEmpty()) {
                process.end(-1, "No recordings to dump. Use jfr start to start a recording.");
            }
            if (this.getRecording() != null) {
                Recording r = recordings.get(this.getRecording());
                if (r == null) {
                    process.end(-1, "recording not exit");
                }
                if (this.getFilename() == null) {
                    try {
                        this.setFilename(this.outputFile());
                    }
                    catch (IOException e) {
                        process.end(-1, e.getMessage());
                    }
                }
                try {
                    r.dump(Paths.get(this.getFilename(), new String[0]));
                }
                catch (IOException e) {
                    process.end(-1, "Could not to dump. " + e.getMessage());
                }
                this.result.setJfrOutput("Dump recording " + r.getId() + ", The result will be written to:\n" + this.getFilename());
            } else {
                process.end(-1, "Failed to dump. Please input recording id");
            }
        } else if ("stop".equals(this.cmd)) {
            if (recordings.isEmpty()) {
                process.end(-1, "No recordings to stop. Use jfr start to start a recording.");
            }
            if (this.getRecording() != null) {
                Recording r = recordings.remove(this.getRecording());
                if (r == null) {
                    process.end(-1, "recording not exit");
                }
                if ("CLOSED".equals(r.getState().toString()) || "STOPPED".equals(r.getState().toString())) {
                    process.end(-1, "Failed to stop recording, state can not be closed/stopped");
                }
                if (this.getFilename() == null) {
                    try {
                        this.setFilename(this.outputFile());
                    }
                    catch (IOException e) {
                        process.end(-1, e.getMessage());
                    }
                }
                try {
                    r.setDestination(Paths.get(this.getFilename(), new String[0]));
                }
                catch (IOException e) {
                    process.end(-1, "Failed to stop " + r.getName() + ". Could not set destination for " + this.filename + "to file" + e.getMessage());
                }
                r.stop();
                this.result.setJfrOutput("Stop recording " + r.getId() + ", The result will be written to:\n" + this.getFilename());
                r.close();
            } else {
                process.end(-1, "Failed to stop. please input recording id");
            }
        } else {
            process.end(-1, "Please input correct jfr command (start status stop dump)");
        }
        process.appendResult(this.result);
        process.end();
    }

    public long parseSize(String s) throws Exception {
        if ((s = s.toLowerCase()).endsWith("b")) {
            return Long.parseLong(s.substring(0, s.length() - 1).trim());
        }
        if (s.endsWith("k")) {
            return 1024L * Long.parseLong(s.substring(0, s.length() - 1).trim());
        }
        if (s.endsWith("m")) {
            return 0x100000L * Long.parseLong(s.substring(0, s.length() - 1).trim());
        }
        if (s.endsWith("g")) {
            return 0x40000000L * Long.parseLong(s.substring(0, s.length() - 1).trim());
        }
        try {
            return Long.parseLong(s);
        }
        catch (Exception e) {
            throw new NumberFormatException("'" + s + "' is not a valid size. Should be numeric value followed by a unit, i.e. 20M. Valid units k, M, G");
        }
    }

    public long parseTimespan(String s) throws Exception {
        if ((s = s.toLowerCase()).endsWith("s")) {
            return TimeUnit.NANOSECONDS.convert(Long.parseLong(s.substring(0, s.length() - 1).trim()), TimeUnit.SECONDS);
        }
        if (s.endsWith("m")) {
            return 60L * TimeUnit.NANOSECONDS.convert(Long.parseLong(s.substring(0, s.length() - 1).trim()), TimeUnit.SECONDS);
        }
        if (s.endsWith("h")) {
            return 3600L * TimeUnit.NANOSECONDS.convert(Long.parseLong(s.substring(0, s.length() - 1).trim()), TimeUnit.SECONDS);
        }
        if (s.endsWith("d")) {
            return 86400L * TimeUnit.NANOSECONDS.convert(Long.parseLong(s.substring(0, s.length() - 1).trim()), TimeUnit.SECONDS);
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException var2) {
            throw new NumberFormatException("'" + s + "' is not a valid timespan. Shoule be numeric value followed by a unit, i.e. 20s. Valid units s, m, h and d.");
        }
    }

    private List<Recording> findRecordingByState(String state) {
        ArrayList<Recording> resultRecordingList = new ArrayList<Recording>();
        Collection<Recording> recordingList = recordings.values();
        for (Recording recording : recordingList) {
            if (!recording.getState().toString().toLowerCase().equals(state)) continue;
            resultRecordingList.add(recording);
        }
        return resultRecordingList;
    }

    private void printRecording(Recording recording) {
        String format = "Recording: recording=" + recording.getId() + " name=" + recording.getName() + "";
        this.result.setJfrOutput(format);
        Duration duration = recording.getDuration();
        if (duration != null) {
            this.result.setJfrOutput(" duration=" + duration.toString());
        }
        this.result.setJfrOutput(" (" + recording.getState().toString().toLowerCase() + ")\n");
    }

    private String outputFile() throws IOException {
        if (this.filename == null) {
            File outputPath = ArthasBootstrap.getInstance().getOutputPath();
            this.filename = outputPath != null ? new File(outputPath, new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()) + ".jfr").getAbsolutePath() : File.createTempFile("arthas-output", ".jfr").getAbsolutePath();
        }
        return this.filename;
    }

    @Override
    public void complete(Completion completion) {
        List<CliToken> tokens = completion.lineTokens();
        String token = tokens.get(tokens.size() - 1).value();
        if (token.startsWith("-")) {
            super.complete(completion);
            return;
        }
        List<String> cmd = Arrays.asList("start", "status", "dump", "stop");
        CompletionUtils.complete(completion, cmd);
    }
}

