/*
 * Decompiled with CFR 0.152.
 */
package java.arthas;

import java.lang.reflect.Method;

public class Spy {
    public static final String ON_BEFORE = "methodOnBegin";
    public static final String ON_RETURN = "methodOnReturnEnd";
    public static final String ON_THROWS = "methodOnThrowingEnd";
    public static final String BEFORE_INVOKE = "methodOnInvokeBeforeTracing";
    public static final String AFTER_INVOKE = "methodOnInvokeAfterTracing";
    public static final String THROW_INVOKE = "methodOnInvokeThrowTracing";
    public static volatile Method ON_BEFORE_METHOD;
    public static volatile Method ON_RETURN_METHOD;
    public static volatile Method ON_THROWS_METHOD;
    public static volatile Method BEFORE_INVOKING_METHOD;
    public static volatile Method AFTER_INVOKING_METHOD;
    public static volatile Method THROW_INVOKING_METHOD;
    public static volatile ClassLoader CLASSLOADER;
    public static volatile Method AGENT_RESET_METHOD;

    public static void init(ClassLoader classLoader, Method onBeforeMethod, Method onReturnMethod, Method onThrowsMethod, Method beforeInvokingMethod, Method afterInvokingMethod, Method throwInvokingMethod) {
        CLASSLOADER = classLoader;
        ON_BEFORE_METHOD = onBeforeMethod;
        ON_RETURN_METHOD = onReturnMethod;
        ON_THROWS_METHOD = onThrowsMethod;
        BEFORE_INVOKING_METHOD = beforeInvokingMethod;
        AFTER_INVOKING_METHOD = afterInvokingMethod;
        THROW_INVOKING_METHOD = throwInvokingMethod;
    }

    public static void destroy() {
        Spy.initEmptySpy();
        if (AGENT_RESET_METHOD != null) {
            try {
                AGENT_RESET_METHOD.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        AGENT_RESET_METHOD = null;
    }

    private static void initEmptySpy() {
        try {
            Class<Spy> adviceWeaverClass = Spy.class;
            Method onBefore = adviceWeaverClass.getMethod(ON_BEFORE, Integer.TYPE, ClassLoader.class, String.class, String.class, String.class, Object.class, Object[].class);
            Method onReturn = adviceWeaverClass.getMethod(ON_RETURN, Object.class);
            Method onThrows = adviceWeaverClass.getMethod(ON_THROWS, Throwable.class);
            Method beforeInvoke = adviceWeaverClass.getMethod(BEFORE_INVOKE, Integer.TYPE, String.class, String.class, String.class, Integer.TYPE);
            Method afterInvoke = adviceWeaverClass.getMethod(AFTER_INVOKE, Integer.TYPE, String.class, String.class, String.class, Integer.TYPE);
            Method throwInvoke = adviceWeaverClass.getMethod(THROW_INVOKE, Integer.TYPE, String.class, String.class, String.class, Integer.TYPE);
            Spy.init(null, onBefore, onReturn, onThrows, beforeInvoke, afterInvoke, throwInvoke);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void methodOnBegin(int adviceId, ClassLoader loader, String className, String methodName, String methodDesc, Object target, Object[] args) {
    }

    public static void methodOnReturnEnd(Object returnObject) {
    }

    public static void methodOnThrowingEnd(Throwable throwable) {
    }

    public static void methodOnInvokeBeforeTracing(int adviceId, String owner, String name, String desc, int lineNumber) {
    }

    public static void methodOnInvokeAfterTracing(int adviceId, String owner, String name, String desc, int lineNumber) {
    }

    public static void methodOnInvokeThrowTracing(int adviceId, String owner, String name, String desc, int lineNumber) {
    }
}

