/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.client;

import com.alibaba.arthas.tunnel.client.ForwardClient;
import com.alibaba.arthas.tunnel.client.ProxyClient;
import com.alibaba.arthas.tunnel.client.TunnelClient;
import com.alibaba.arthas.tunnel.common.SimpleHttpResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.QueryStringEncoder;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.CharsetUtil;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelClientSocketClientHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private static final Logger logger = LoggerFactory.getLogger(TunnelClientSocketClientHandler.class);
    private final TunnelClient tunnelClient;
    private ChannelPromise registerPromise;

    public TunnelClientSocketClientHandler(TunnelClient tunnelClient) {
        this.tunnelClient = tunnelClient;
    }

    public ChannelFuture registerFuture() {
        return this.registerPromise;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.registerPromise = ctx.newPromise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead0(ChannelHandlerContext ctx, WebSocketFrame frame) throws Exception {
        if (frame instanceof TextWebSocketFrame) {
            TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
            String text = textFrame.text();
            logger.info("receive TextWebSocketFrame: {}", (Object)text);
            QueryStringDecoder queryDecoder = new QueryStringDecoder(text);
            Map parameters = queryDecoder.parameters();
            List methodList = (List)parameters.get("method");
            String method = null;
            if (methodList != null && !methodList.isEmpty()) {
                method = (String)methodList.get(0);
            }
            if ("agentRegister".equals(method)) {
                List idList = (List)parameters.get("id");
                if (idList != null && !idList.isEmpty()) {
                    this.tunnelClient.setId((String)idList.get(0));
                }
                this.tunnelClient.setConnected(true);
                this.registerPromise.setSuccess();
            }
            if ("startTunnel".equals(method)) {
                QueryStringEncoder queryEncoder = new QueryStringEncoder(this.tunnelClient.getTunnelServerUrl());
                queryEncoder.addParam("method", "openTunnel");
                queryEncoder.addParam("clientConnectionId", (String)((List)parameters.get("clientConnectionId")).get(0));
                queryEncoder.addParam("id", (String)((List)parameters.get("id")).get(0));
                URI forwardUri = queryEncoder.toUri();
                logger.info("start ForwardClient, uri: {}", (Object)forwardUri);
                try {
                    ForwardClient forwardClient = new ForwardClient(forwardUri);
                    forwardClient.start();
                }
                catch (Throwable e) {
                    logger.error("start ForwardClient error, forwardUri: {}", (Object)forwardUri, (Object)e);
                }
            }
            if ("httpProxy".equals(method)) {
                ProxyClient proxyClient = new ProxyClient();
                List targetUrls = (List)parameters.get("targetUrl");
                List requestIDs = (List)parameters.get("requestId");
                String id = null;
                if (requestIDs != null && !requestIDs.isEmpty()) {
                    id = (String)requestIDs.get(0);
                }
                if (id == null) {
                    logger.error("error, http proxy need {}", (Object)"requestId");
                    return;
                }
                if (targetUrls != null && !targetUrls.isEmpty()) {
                    String targetUrl = (String)targetUrls.get(0);
                    SimpleHttpResponse simpleHttpResponse = proxyClient.query(targetUrl);
                    ByteBuf byteBuf = null;
                    try {
                        byteBuf = Base64.encode((ByteBuf)Unpooled.wrappedBuffer((byte[])SimpleHttpResponse.toBytes((SimpleHttpResponse)simpleHttpResponse)));
                        String requestData = byteBuf.toString(CharsetUtil.UTF_8);
                        QueryStringEncoder queryEncoder = new QueryStringEncoder("");
                        queryEncoder.addParam("method", "httpProxy");
                        queryEncoder.addParam("requestId", id);
                        queryEncoder.addParam("responseData", requestData);
                        String url = queryEncoder.toString();
                        ctx.writeAndFlush((Object)new TextWebSocketFrame(url));
                    }
                    finally {
                        if (byteBuf != null) {
                            byteBuf.release();
                        }
                    }
                }
            }
        }
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.tunnelClient.setConnected(false);
        ctx.channel().eventLoop().schedule(new Runnable(){

            @Override
            public void run() {
                logger.error("try to reconnect to tunnel server, uri: {}", (Object)TunnelClientSocketClientHandler.this.tunnelClient.getTunnelServerUrl());
                try {
                    TunnelClientSocketClientHandler.this.tunnelClient.connect(true);
                }
                catch (Throwable e) {
                    logger.error("reconnect error", e);
                }
            }
        }, (long)this.tunnelClient.getReconnectDelay(), TimeUnit.SECONDS);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            ctx.writeAndFlush((Object)new PingWebSocketFrame());
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("TunnelClient error, tunnel server url: " + this.tunnelClient.getTunnelServerUrl(), cause);
        if (!this.registerPromise.isDone()) {
            this.registerPromise.setFailure(cause);
        }
        ctx.close();
    }
}

