/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.server;

import com.alibaba.arthas.tunnel.common.SimpleHttpResponse;
import com.alibaba.arthas.tunnel.server.AgentClusterInfo;
import com.alibaba.arthas.tunnel.server.AgentInfo;
import com.alibaba.arthas.tunnel.server.ClientConnectionInfo;
import com.alibaba.arthas.tunnel.server.TunnelSocketServerInitializer;
import com.alibaba.arthas.tunnel.server.cluster.TunnelClusterStore;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Promise;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelServer {
    private static final Logger logger = LoggerFactory.getLogger(TunnelServer.class);
    public static final String DEFAULT_WEBSOCKET_PATH = "/ws";
    private boolean ssl;
    private String host;
    private int port;
    private String path = "/ws";
    private Map<String, AgentInfo> agentInfoMap = new ConcurrentHashMap<String, AgentInfo>();
    private Map<String, ClientConnectionInfo> clientConnectionInfoMap = new ConcurrentHashMap<String, ClientConnectionInfo>();
    private Map<String, Promise<SimpleHttpResponse>> proxyRequestPromiseMap = new ConcurrentHashMap<String, Promise<SimpleHttpResponse>>();
    private EventLoopGroup bossGroup = new NioEventLoopGroup(1, (ThreadFactory)new DefaultThreadFactory("arthas-TunnelServer-boss", true));
    private EventLoopGroup workerGroup = new NioEventLoopGroup((ThreadFactory)new DefaultThreadFactory("arthas-TunnelServer-worker", true));
    private Channel channel;
    private TunnelClusterStore tunnelClusterStore;
    private String clientConnectHost;

    public void start() throws Exception {
        SslContext sslCtx;
        if (this.ssl) {
            SelfSignedCertificate ssc = new SelfSignedCertificate();
            sslCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build();
        } else {
            sslCtx = null;
        }
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new TunnelSocketServerInitializer(this, sslCtx));
        this.channel = StringUtils.isBlank((CharSequence)this.host) ? b.bind(this.port).sync().channel() : b.bind(this.host, this.port).sync().channel();
        logger.info("Tunnel server listen at {}:{}", (Object)this.host, (Object)this.port);
        this.workerGroup.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                TunnelServer.this.agentInfoMap.entrySet().removeIf(e -> !((AgentInfo)e.getValue()).getChannelHandlerContext().channel().isActive());
                TunnelServer.this.clientConnectionInfoMap.entrySet().removeIf(e -> !((ClientConnectionInfo)e.getValue()).getChannelHandlerContext().channel().isActive());
                if (TunnelServer.this.tunnelClusterStore != null && TunnelServer.this.clientConnectHost != null) {
                    try {
                        for (Map.Entry entry : TunnelServer.this.agentInfoMap.entrySet()) {
                            TunnelServer.this.tunnelClusterStore.addAgent((String)entry.getKey(), new AgentClusterInfo((AgentInfo)entry.getValue(), TunnelServer.this.clientConnectHost), 3600L, TimeUnit.SECONDS);
                        }
                    }
                    catch (Throwable t) {
                        logger.error("update tunnel info error", t);
                    }
                }
            }
        }, 60L, 60L, TimeUnit.SECONDS);
    }

    public void stop() {
        if (this.channel != null) {
            this.channel.close();
        }
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }

    public Optional<AgentInfo> findAgent(String id) {
        return Optional.ofNullable(this.agentInfoMap.get(id));
    }

    public void addAgent(String id, AgentInfo agentInfo) {
        this.agentInfoMap.put(id, agentInfo);
        if (this.tunnelClusterStore != null) {
            this.tunnelClusterStore.addAgent(id, new AgentClusterInfo(agentInfo, this.clientConnectHost), 3600L, TimeUnit.SECONDS);
        }
    }

    public AgentInfo removeAgent(String id) {
        AgentInfo agentInfo = this.agentInfoMap.remove(id);
        if (this.tunnelClusterStore != null) {
            this.tunnelClusterStore.removeAgent(id);
        }
        return agentInfo;
    }

    public Optional<ClientConnectionInfo> findClientConnection(String id) {
        return Optional.ofNullable(this.clientConnectionInfoMap.get(id));
    }

    public void addClientConnectionInfo(String id, ClientConnectionInfo clientConnectionInfo) {
        this.clientConnectionInfoMap.put(id, clientConnectionInfo);
    }

    public ClientConnectionInfo removeClientConnectionInfo(String id) {
        return this.clientConnectionInfoMap.remove(id);
    }

    public void addProxyRequestPromise(final String requestId, Promise<SimpleHttpResponse> promise) {
        this.proxyRequestPromiseMap.put(requestId, promise);
        this.workerGroup.schedule(new Runnable(){

            @Override
            public void run() {
                TunnelServer.this.removeProxyRequestPromise(requestId);
            }
        }, 60L, TimeUnit.SECONDS);
    }

    public void removeProxyRequestPromise(String requestId) {
        this.proxyRequestPromiseMap.remove(requestId);
    }

    public Promise<SimpleHttpResponse> findProxyRequestPromise(String requestId) {
        return this.proxyRequestPromiseMap.get(requestId);
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Map<String, AgentInfo> getAgentInfoMap() {
        return this.agentInfoMap;
    }

    public void setAgentInfoMap(Map<String, AgentInfo> agentInfoMap) {
        this.agentInfoMap = agentInfoMap;
    }

    public Map<String, ClientConnectionInfo> getClientConnectionInfoMap() {
        return this.clientConnectionInfoMap;
    }

    public void setClientConnectionInfoMap(Map<String, ClientConnectionInfo> clientConnectionInfoMap) {
        this.clientConnectionInfoMap = clientConnectionInfoMap;
    }

    public TunnelClusterStore getTunnelClusterStore() {
        return this.tunnelClusterStore;
    }

    public void setTunnelClusterStore(TunnelClusterStore tunnelClusterStore) {
        this.tunnelClusterStore = tunnelClusterStore;
    }

    public String getClientConnectHost() {
        return this.clientConnectHost;
    }

    public void setClientConnectHost(String clientConnectHost) {
        this.clientConnectHost = clientConnectHost;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        if (!(path = path.trim()).startsWith("/")) {
            logger.warn("tunnel server path should start with / ! path: {}, try to auto add / .", (Object)path);
            path = "/" + path;
        }
        this.path = path;
    }
}

