/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.server;

import com.alibaba.arthas.tunnel.server.TunnelServer;
import com.alibaba.arthas.tunnel.server.TunnelSocketFrameHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.handler.ssl.SslContext;

public class TunnelSocketServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final SslContext sslCtx;
    private TunnelServer tunnelServer;

    public TunnelSocketServerInitializer(TunnelServer tunnelServer, SslContext sslCtx) {
        this.sslCtx = sslCtx;
        this.tunnelServer = tunnelServer;
    }

    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.sslCtx != null) {
            pipeline.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
        pipeline.addLast(new ChannelHandler[]{new WebSocketServerCompressionHandler()});
        pipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(this.tunnelServer.getPath(), null, true, 0x800000, false, true, 10000L)});
        pipeline.addLast(new ChannelHandler[]{new TunnelSocketFrameHandler(this.tunnelServer)});
    }
}

