/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.server;

import com.alibaba.arthas.tunnel.common.SimpleHttpResponse;
import com.alibaba.arthas.tunnel.server.AgentInfo;
import com.alibaba.arthas.tunnel.server.ChannelUtils;
import com.alibaba.arthas.tunnel.server.ClientConnectionInfo;
import com.alibaba.arthas.tunnel.server.RelayHandler;
import com.alibaba.arthas.tunnel.server.TunnelServer;
import com.alibaba.arthas.tunnel.server.utils.HttpUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.tomcat.util.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class TunnelSocketFrameHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private static final Logger logger = LoggerFactory.getLogger(TunnelSocketFrameHandler.class);
    private TunnelServer tunnelServer;

    public TunnelSocketFrameHandler(TunnelServer tunnelServer) {
        this.tunnelServer = tunnelServer;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof WebSocketServerProtocolHandler.HandshakeComplete) {
            WebSocketServerProtocolHandler.HandshakeComplete handshake = (WebSocketServerProtocolHandler.HandshakeComplete)evt;
            String uri = handshake.requestUri();
            logger.info("websocket handshake complete, uri: {}", (Object)uri);
            MultiValueMap parameters = UriComponentsBuilder.fromUriString((String)uri).build().getQueryParams();
            String method = (String)parameters.getFirst((Object)"method");
            if ("connectArthas".equals(method)) {
                this.connectArthas(ctx, (MultiValueMap<String, String>)parameters);
            } else if ("agentRegister".equals(method)) {
                this.agentRegister(ctx, handshake, uri);
            }
            if ("openTunnel".equals(method)) {
                String clientConnectionId = (String)parameters.getFirst((Object)"clientConnectionId");
                this.openTunnel(ctx, clientConnectionId);
            }
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame frame) throws Exception {
        TextWebSocketFrame textFrame;
        String text;
        MultiValueMap parameters;
        String method;
        if (frame instanceof TextWebSocketFrame && "httpProxy".equals(method = (String)(parameters = UriComponentsBuilder.fromUriString((String)(text = (textFrame = (TextWebSocketFrame)frame).text())).build().getQueryParams()).getFirst((Object)"method"))) {
            String requestId = URLDecoder.decode((String)parameters.getFirst((Object)"requestId"), "utf-8");
            if (requestId == null) {
                logger.error("error, need {}, text: {}", (Object)"requestId", (Object)text);
                return;
            }
            logger.info("received http proxy response, requestId: {}", (Object)requestId);
            Promise<SimpleHttpResponse> promise = this.tunnelServer.findProxyRequestPromise(requestId);
            String data = URLDecoder.decode((String)parameters.getFirst((Object)"responseData"), "utf-8");
            byte[] bytes = Base64.decodeBase64((String)data);
            SimpleHttpResponse simpleHttpResponse = SimpleHttpResponse.fromBytes((byte[])bytes);
            promise.setSuccess((Object)simpleHttpResponse);
        }
    }

    private void connectArthas(final ChannelHandlerContext tunnelSocketCtx, MultiValueMap<String, String> parameters) throws URISyntaxException {
        final List agentId = (List)parameters.getOrDefault((Object)"id", Collections.emptyList());
        if (agentId.isEmpty()) {
            logger.error("arthas agent id can not be null, parameters: {}", parameters);
            throw new IllegalArgumentException("arthas agent id can not be null");
        }
        logger.info("try to connect to arthas agent, id: " + (String)agentId.get(0));
        Optional<AgentInfo> findAgent = this.tunnelServer.findAgent((String)agentId.get(0));
        if (findAgent.isPresent()) {
            final ChannelHandlerContext agentCtx = findAgent.get().getChannelHandlerContext();
            final String clientConnectionId = RandomStringUtils.random((int)20, (boolean)true, (boolean)true).toUpperCase();
            logger.info("random clientConnectionId: " + clientConnectionId);
            URI uri = UriComponentsBuilder.newInstance().scheme("response").path("/").queryParam("method", new Object[]{"startTunnel"}).queryParam("id", (Collection)agentId).queryParam("clientConnectionId", new Object[]{clientConnectionId}).build().toUri();
            logger.info("startTunnel response: " + uri);
            ClientConnectionInfo clientConnectionInfo = new ClientConnectionInfo();
            SocketAddress remoteAddress = tunnelSocketCtx.channel().remoteAddress();
            if (remoteAddress instanceof InetSocketAddress) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteAddress;
                clientConnectionInfo.setHost(inetSocketAddress.getHostString());
                clientConnectionInfo.setPort(inetSocketAddress.getPort());
            }
            clientConnectionInfo.setChannelHandlerContext(tunnelSocketCtx);
            Promise promise = GlobalEventExecutor.INSTANCE.newPromise();
            promise.addListener((GenericFutureListener)new FutureListener<Channel>(){

                public void operationComplete(Future<Channel> future) throws Exception {
                    Channel outboundChannel = (Channel)future.getNow();
                    if (future.isSuccess()) {
                        tunnelSocketCtx.pipeline().remove((ChannelHandler)TunnelSocketFrameHandler.this);
                        outboundChannel.pipeline().removeLast();
                        outboundChannel.pipeline().addLast(new ChannelHandler[]{new RelayHandler(tunnelSocketCtx.channel())});
                        tunnelSocketCtx.pipeline().addLast(new ChannelHandler[]{new RelayHandler(outboundChannel)});
                    } else {
                        logger.error("wait for agent connect error. agentId: {}, clientConnectionId: {}", (Object)agentId, (Object)clientConnectionId);
                        ChannelUtils.closeOnFlush(agentCtx.channel());
                    }
                }
            });
            clientConnectionInfo.setPromise((Promise<Channel>)promise);
            this.tunnelServer.addClientConnectionInfo(clientConnectionId, clientConnectionInfo);
            tunnelSocketCtx.channel().closeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

                public void operationComplete(Future<? super Void> future) throws Exception {
                    TunnelSocketFrameHandler.this.tunnelServer.removeClientConnectionInfo(clientConnectionId);
                }
            });
            agentCtx.channel().writeAndFlush((Object)new TextWebSocketFrame(uri.toString()));
            logger.info("browser connect waitting for arthas agent open tunnel");
            boolean watiResult = promise.awaitUninterruptibly(20L, TimeUnit.SECONDS);
            if (watiResult) {
                logger.info("browser connect wait for arthas agent open tunnel success, agentId: {}, clientConnectionId: {}", (Object)agentId, (Object)clientConnectionId);
            } else {
                logger.error("browser connect wait for arthas agent open tunnel timeout, agentId: {}, clientConnectionId: {}", (Object)agentId, (Object)clientConnectionId);
                tunnelSocketCtx.close();
            }
        } else {
            tunnelSocketCtx.channel().writeAndFlush((Object)new CloseWebSocketFrame(2000, "Can not find arthas agent by id: " + agentId));
            logger.error("Can not find arthas agent by id: {}", (Object)agentId);
            throw new IllegalArgumentException("Can not find arthas agent by id: " + agentId);
        }
    }

    private void agentRegister(ChannelHandlerContext ctx, WebSocketServerProtocolHandler.HandshakeComplete handshake, String requestUri) throws URISyntaxException {
        QueryStringDecoder queryDecoder = new QueryStringDecoder(requestUri);
        Map parameters = queryDecoder.parameters();
        String appName = null;
        List appNameList = (List)parameters.get("appName");
        if (appNameList != null && !appNameList.isEmpty()) {
            appName = (String)appNameList.get(0);
        }
        String id = null;
        id = appName != null ? appName + "_" + RandomStringUtils.random((int)20, (boolean)true, (boolean)true).toUpperCase() : RandomStringUtils.random((int)20, (boolean)true, (boolean)true).toUpperCase();
        List idList = (List)parameters.get("id");
        if (idList != null && !idList.isEmpty()) {
            id = (String)idList.get(0);
        }
        String arthasVersion = null;
        List arthasVersionList = (List)parameters.get("arthasVersion");
        if (arthasVersionList != null && !arthasVersionList.isEmpty()) {
            arthasVersion = (String)arthasVersionList.get(0);
        }
        final String finalId = id;
        URI responseUri = UriComponentsBuilder.newInstance().scheme("response").path("/").queryParam("method", new Object[]{"agentRegister"}).queryParam("id", new Object[]{id}).build().encode().toUri();
        AgentInfo info = new AgentInfo();
        HttpHeaders headers = handshake.requestHeaders();
        String host = HttpUtils.findClientIP(headers);
        if (host == null) {
            SocketAddress remoteAddress = ctx.channel().remoteAddress();
            if (remoteAddress instanceof InetSocketAddress) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteAddress;
                info.setHost(inetSocketAddress.getHostString());
                info.setPort(inetSocketAddress.getPort());
            }
        } else {
            info.setHost(host);
            Integer port = HttpUtils.findClientPort(headers);
            if (port != null) {
                info.setPort(port);
            }
        }
        info.setChannelHandlerContext(ctx);
        if (arthasVersion != null) {
            info.setArthasVersion(arthasVersion);
        }
        this.tunnelServer.addAgent(id, info);
        ctx.channel().closeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> future) throws Exception {
                TunnelSocketFrameHandler.this.tunnelServer.removeAgent(finalId);
            }
        });
        ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(responseUri.toString()));
    }

    private void openTunnel(ChannelHandlerContext ctx, String clientConnectionId) {
        Optional<ClientConnectionInfo> infoOptional = this.tunnelServer.findClientConnection(clientConnectionId);
        if (infoOptional.isPresent()) {
            ClientConnectionInfo info = infoOptional.get();
            logger.info("openTunnel clientConnectionId:" + clientConnectionId);
            Promise<Channel> promise = info.getPromise();
            promise.setSuccess((Object)ctx.channel());
        } else {
            logger.error("Can not find client connection by id: {}", (Object)clientConnectionId);
        }
    }
}

