/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.server.cluster;

import com.alibaba.arthas.tunnel.server.AgentClusterInfo;
import com.alibaba.arthas.tunnel.server.cluster.TunnelClusterStore;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;

public class RedisTunnelClusterStore
implements TunnelClusterStore {
    private static final Logger logger = LoggerFactory.getLogger(RedisTunnelClusterStore.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private String prefix = "arthas-tunnel-agent-";
    private StringRedisTemplate redisTemplate;

    @Override
    public AgentClusterInfo findAgent(String agentId) {
        try {
            ValueOperations opsForValue = this.redisTemplate.opsForValue();
            String infoStr = (String)opsForValue.get((Object)(this.prefix + agentId));
            if (infoStr == null) {
                throw new IllegalArgumentException("can not find info for agentId: " + agentId);
            }
            AgentClusterInfo info = (AgentClusterInfo)MAPPER.readValue(infoStr, AgentClusterInfo.class);
            return info;
        }
        catch (Throwable e) {
            logger.error("try to read agentInfo error. agentId:{}", (Object)agentId, (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeAgent(String agentId) {
        ValueOperations opsForValue = this.redisTemplate.opsForValue();
        opsForValue.getOperations().delete((Object)(this.prefix + agentId));
    }

    @Override
    public void addAgent(String agentId, AgentClusterInfo info, long timeout, TimeUnit timeUnit) {
        try {
            ValueOperations opsForValue = this.redisTemplate.opsForValue();
            String infoStr = MAPPER.writeValueAsString((Object)info);
            opsForValue.set((Object)(this.prefix + agentId), (Object)infoStr, timeout, timeUnit);
        }
        catch (Throwable e) {
            logger.error("try to add agentInfo error. agentId:{}", (Object)agentId, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public StringRedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(StringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public Collection<String> allAgentIds() {
        ValueOperations opsForValue = this.redisTemplate.opsForValue();
        int length = this.prefix.length();
        Set redisValues = opsForValue.getOperations().keys((Object)(this.prefix + "*"));
        if (redisValues != null) {
            ArrayList<String> result = new ArrayList<String>(redisValues.size());
            for (String value : redisValues) {
                result.add(value.substring(length));
            }
            return result;
        }
        logger.error("try to get allAgentIds error. redis returned null.");
        return Collections.emptyList();
    }

    @Override
    public Map<String, AgentClusterInfo> agentInfo(String appName) {
        try {
            ValueOperations opsForValue = this.redisTemplate.opsForValue();
            String prefixWithAppName = this.prefix + appName + "_";
            ArrayList keys = new ArrayList(opsForValue.getOperations().keys((Object)(prefixWithAppName + "*")));
            List values = opsForValue.getOperations().opsForValue().multiGet(keys);
            HashMap<String, AgentClusterInfo> result = new HashMap<String, AgentClusterInfo>();
            Iterator iterator = values.iterator();
            for (String key : keys) {
                String infoStr = (String)iterator.next();
                AgentClusterInfo info = (AgentClusterInfo)MAPPER.readValue(infoStr, AgentClusterInfo.class);
                String agentId = key.substring(this.prefix.length());
                result.put(agentId, info);
            }
            return result;
        }
        catch (Throwable e) {
            logger.error("try to query agentInfo error. appName:{}", (Object)appName, (Object)e);
            throw new RuntimeException(e);
        }
    }
}

