/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.support;

import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.ConnectFuture;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IdleStatus;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoFilter;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoFilterAdapter;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoFilterChain;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoFilterLifeCycleException;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoSession;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.util.ByteBufferUtil;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.util.SessionLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIoFilterChain
implements IoFilterChain {
    public static final String CONNECT_FUTURE = AbstractIoFilterChain.class.getName() + ".connectFuture";
    private final IoSession session;
    private final Map<String, IoFilterChain.Entry> name2entry = new HashMap<String, IoFilterChain.Entry>();
    private final EntryImpl head;
    private final EntryImpl tail;

    protected AbstractIoFilterChain(IoSession session) {
        if (session == null) {
            throw new NullPointerException("session");
        }
        this.session = session;
        this.head = new EntryImpl(null, null, "head", new HeadFilter());
        this.tail = new EntryImpl(this.head, null, "tail", new TailFilter());
        this.head.nextEntry = this.tail;
    }

    @Override
    public IoSession getSession() {
        return this.session;
    }

    @Override
    public IoFilterChain.Entry getEntry(String name) {
        IoFilterChain.Entry e = this.name2entry.get(name);
        if (e == null) {
            return null;
        }
        return e;
    }

    @Override
    public IoFilter get(String name) {
        IoFilterChain.Entry e = this.getEntry(name);
        if (e == null) {
            return null;
        }
        return e.getFilter();
    }

    @Override
    public IoFilter.NextFilter getNextFilter(String name) {
        IoFilterChain.Entry e = this.getEntry(name);
        if (e == null) {
            return null;
        }
        return e.getNextFilter();
    }

    @Override
    public synchronized void addFirst(String name, IoFilter filter) {
        this.checkAddable(name);
        this.register(this.head, name, filter);
    }

    @Override
    public synchronized void addLast(String name, IoFilter filter) {
        this.checkAddable(name);
        this.register(this.tail.prevEntry, name, filter);
    }

    @Override
    public synchronized void addBefore(String baseName, String name, IoFilter filter) {
        EntryImpl baseEntry = this.checkOldName(baseName);
        this.checkAddable(name);
        this.register(baseEntry.prevEntry, name, filter);
    }

    @Override
    public synchronized void addAfter(String baseName, String name, IoFilter filter) {
        EntryImpl baseEntry = this.checkOldName(baseName);
        this.checkAddable(name);
        this.register(baseEntry, name, filter);
    }

    @Override
    public synchronized IoFilter remove(String name) {
        EntryImpl entry = this.checkOldName(name);
        this.deregister(entry);
        return entry.getFilter();
    }

    @Override
    public synchronized void clear() throws Exception {
        Iterator<String> it = new ArrayList<String>(this.name2entry.keySet()).iterator();
        while (it.hasNext()) {
            this.remove(it.next());
        }
    }

    private void register(EntryImpl prevEntry, String name, IoFilter filter) {
        EntryImpl newEntry = new EntryImpl(prevEntry, prevEntry.nextEntry, name, filter);
        try {
            filter.onPreAdd(this, name, newEntry.getNextFilter());
        }
        catch (Exception e) {
            throw new IoFilterLifeCycleException("onPreAdd(): " + name + ':' + filter + " in " + this.getSession(), e);
        }
        prevEntry.nextEntry.prevEntry = newEntry;
        prevEntry.nextEntry = newEntry;
        this.name2entry.put(name, newEntry);
        try {
            filter.onPostAdd(this, name, newEntry.getNextFilter());
        }
        catch (Exception e) {
            this.deregister0(newEntry);
            throw new IoFilterLifeCycleException("onPostAdd(): " + name + ':' + filter + " in " + this.getSession(), e);
        }
    }

    private void deregister(EntryImpl entry) {
        IoFilter filter = entry.getFilter();
        try {
            filter.onPreRemove(this, entry.getName(), entry.getNextFilter());
        }
        catch (Exception e) {
            throw new IoFilterLifeCycleException("onPreRemove(): " + entry.getName() + ':' + filter + " in " + this.getSession(), e);
        }
        this.deregister0(entry);
        try {
            filter.onPostRemove(this, entry.getName(), entry.getNextFilter());
        }
        catch (Exception e) {
            throw new IoFilterLifeCycleException("onPostRemove(): " + entry.getName() + ':' + filter + " in " + this.getSession(), e);
        }
    }

    private void deregister0(EntryImpl entry) {
        EntryImpl prevEntry = entry.prevEntry;
        EntryImpl nextEntry = entry.nextEntry;
        prevEntry.nextEntry = nextEntry;
        nextEntry.prevEntry = prevEntry;
        this.name2entry.remove(entry.name);
    }

    private EntryImpl checkOldName(String baseName) {
        EntryImpl e = (EntryImpl)this.name2entry.get(baseName);
        if (e == null) {
            throw new IllegalArgumentException("Unknown filter name:" + baseName);
        }
        return e;
    }

    private void checkAddable(String name) {
        if (this.name2entry.containsKey(name)) {
            throw new IllegalArgumentException("Other filter is using the same name '" + name + "'");
        }
    }

    @Override
    public void fireSessionCreated(IoSession session) {
        EntryImpl head = this.head;
        this.callNextSessionCreated(head, session);
    }

    private void callNextSessionCreated(IoFilterChain.Entry entry, IoSession session) {
        try {
            entry.getFilter().sessionCreated(entry.getNextFilter(), session);
        }
        catch (Throwable e) {
            this.fireExceptionCaught(session, e);
        }
    }

    @Override
    public void fireSessionOpened(IoSession session) {
        EntryImpl head = this.head;
        this.callNextSessionOpened(head, session);
    }

    private void callNextSessionOpened(IoFilterChain.Entry entry, IoSession session) {
        try {
            entry.getFilter().sessionOpened(entry.getNextFilter(), session);
        }
        catch (Throwable e) {
            this.fireExceptionCaught(session, e);
        }
    }

    @Override
    public void fireSessionClosed(IoSession session) {
        try {
            session.getCloseFuture().setClosed(null);
        }
        catch (Throwable t) {
            this.fireExceptionCaught(session, t);
        }
        EntryImpl head = this.head;
        this.callNextSessionClosed(head, session);
    }

    private void callNextSessionClosed(IoFilterChain.Entry entry, IoSession session) {
        try {
            entry.getFilter().sessionClosed(entry.getNextFilter(), session);
        }
        catch (Throwable e) {
            this.fireExceptionCaught(session, e);
        }
    }

    @Override
    public void fireSessionIdle(IoSession session, IdleStatus status) {
        EntryImpl head = this.head;
        this.callNextSessionIdle(head, session, status);
    }

    private void callNextSessionIdle(IoFilterChain.Entry entry, IoSession session, IdleStatus status) {
        try {
            entry.getFilter().sessionIdle(entry.getNextFilter(), session, status);
        }
        catch (Throwable e) {
            this.fireExceptionCaught(session, e);
        }
    }

    @Override
    public void fireMessageReceived(IoSession session, Object message) {
        EntryImpl head = this.head;
        this.callNextMessageReceived(head, session, message);
    }

    private void callNextMessageReceived(IoFilterChain.Entry entry, IoSession session, Object message) {
        try {
            entry.getFilter().messageReceived(entry.getNextFilter(), session, message);
        }
        catch (Throwable e) {
            this.fireExceptionCaught(session, e);
        }
    }

    @Override
    public void fireMessageSent(IoSession session, IoFilter.WriteRequest request) {
        try {
            request.getFuture().setWritten(true, null);
        }
        catch (Throwable t) {
            this.fireExceptionCaught(session, t);
        }
        EntryImpl head = this.head;
        this.callNextMessageSent(head, session, request.getMessage());
    }

    private void callNextMessageSent(IoFilterChain.Entry entry, IoSession session, Object message) {
        try {
            entry.getFilter().messageSent(entry.getNextFilter(), session, message);
        }
        catch (Throwable e) {
            this.fireExceptionCaught(session, e);
        }
    }

    @Override
    public void fireExceptionCaught(IoSession session, Throwable cause) {
        ConnectFuture future = (ConnectFuture)session.removeAttribute(CONNECT_FUTURE);
        if (future == null) {
            EntryImpl head = this.head;
            this.callNextExceptionCaught(head, session, cause);
        } else {
            future.setException(cause, null);
        }
    }

    private void callNextExceptionCaught(IoFilterChain.Entry entry, IoSession session, Throwable cause) {
        try {
            entry.getFilter().exceptionCaught(entry.getNextFilter(), session, cause);
        }
        catch (Throwable e) {
            SessionLog.warn(session, "Unexpected exception from exceptionCaught handler.", e);
        }
    }

    @Override
    public void fireFilterWrite(IoSession session, IoFilter.WriteRequest writeRequest) {
        EntryImpl tail = this.tail;
        this.callPreviousFilterWrite(tail, session, writeRequest);
    }

    private void callPreviousFilterWrite(IoFilterChain.Entry entry, IoSession session, IoFilter.WriteRequest writeRequest) {
        try {
            entry.getFilter().filterWrite(entry.getNextFilter(), session, writeRequest);
        }
        catch (Throwable e) {
            writeRequest.getFuture().setWritten(false, e.toString());
            this.fireExceptionCaught(session, e);
        }
    }

    @Override
    public void fireFilterClose(IoSession session) {
        EntryImpl tail = this.tail;
        this.callPreviousFilterClose(tail, session);
    }

    private void callPreviousFilterClose(IoFilterChain.Entry entry, IoSession session) {
        try {
            entry.getFilter().filterClose(entry.getNextFilter(), session);
        }
        catch (Throwable e) {
            this.fireExceptionCaught(session, e);
        }
    }

    @Override
    public List<IoFilterChain.Entry> getAll() {
        ArrayList<IoFilterChain.Entry> list = new ArrayList<IoFilterChain.Entry>();
        EntryImpl e = this.head.nextEntry;
        while (e != this.tail) {
            list.add(e);
            e = e.nextEntry;
        }
        return list;
    }

    @Override
    public List<IoFilterChain.Entry> getAllReversed() {
        ArrayList<IoFilterChain.Entry> list = new ArrayList<IoFilterChain.Entry>();
        EntryImpl e = this.tail.prevEntry;
        while (e != this.head) {
            list.add(e);
            e = e.prevEntry;
        }
        return list;
    }

    @Override
    public boolean contains(String name) {
        return this.getEntry(name) != null;
    }

    @Override
    public boolean contains(IoFilter filter) {
        EntryImpl e = this.head.nextEntry;
        while (e != this.tail) {
            if (e.getFilter() == filter) {
                return true;
            }
            e = e.nextEntry;
        }
        return false;
    }

    @Override
    public boolean contains(Class<? extends IoFilter> filterType) {
        EntryImpl e = this.head.nextEntry;
        while (e != this.tail) {
            if (filterType.isAssignableFrom(e.getFilter().getClass())) {
                return true;
            }
            e = e.nextEntry;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{ ");
        boolean empty = true;
        EntryImpl e = this.head.nextEntry;
        while (e != this.tail) {
            if (!empty) {
                buf.append(", ");
            } else {
                empty = false;
            }
            buf.append('(');
            buf.append(e.getName());
            buf.append(':');
            buf.append(e.getFilter());
            buf.append(')');
            e = e.nextEntry;
        }
        if (empty) {
            buf.append("empty");
        }
        buf.append(" }");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.clear();
        }
        finally {
            super.finalize();
        }
    }

    protected abstract void doWrite(IoSession var1, IoFilter.WriteRequest var2) throws Exception;

    protected abstract void doClose(IoSession var1) throws Exception;

    private class EntryImpl
    implements IoFilterChain.Entry {
        private EntryImpl prevEntry;
        private EntryImpl nextEntry;
        private final String name;
        private final IoFilter filter;
        private final IoFilter.NextFilter nextFilter;

        private EntryImpl(EntryImpl prevEntry, EntryImpl nextEntry, String name, IoFilter filter) {
            if (filter == null) {
                throw new NullPointerException("filter");
            }
            if (name == null) {
                throw new NullPointerException("name");
            }
            this.prevEntry = prevEntry;
            this.nextEntry = nextEntry;
            this.name = name;
            this.filter = filter;
            this.nextFilter = new IoFilter.NextFilter(){

                public void sessionCreated(IoSession session) {
                    EntryImpl nextEntry = EntryImpl.this.nextEntry;
                    AbstractIoFilterChain.this.callNextSessionCreated(nextEntry, session);
                }

                public void sessionOpened(IoSession session) {
                    EntryImpl nextEntry = EntryImpl.this.nextEntry;
                    AbstractIoFilterChain.this.callNextSessionOpened(nextEntry, session);
                }

                public void sessionClosed(IoSession session) {
                    EntryImpl nextEntry = EntryImpl.this.nextEntry;
                    AbstractIoFilterChain.this.callNextSessionClosed(nextEntry, session);
                }

                public void sessionIdle(IoSession session, IdleStatus status) {
                    EntryImpl nextEntry = EntryImpl.this.nextEntry;
                    AbstractIoFilterChain.this.callNextSessionIdle(nextEntry, session, status);
                }

                public void exceptionCaught(IoSession session, Throwable cause) {
                    EntryImpl nextEntry = EntryImpl.this.nextEntry;
                    AbstractIoFilterChain.this.callNextExceptionCaught(nextEntry, session, cause);
                }

                public void messageReceived(IoSession session, Object message) {
                    EntryImpl nextEntry = EntryImpl.this.nextEntry;
                    AbstractIoFilterChain.this.callNextMessageReceived(nextEntry, session, message);
                }

                public void messageSent(IoSession session, Object message) {
                    EntryImpl nextEntry = EntryImpl.this.nextEntry;
                    AbstractIoFilterChain.this.callNextMessageSent(nextEntry, session, message);
                }

                public void filterWrite(IoSession session, IoFilter.WriteRequest writeRequest) {
                    EntryImpl nextEntry = EntryImpl.this.prevEntry;
                    AbstractIoFilterChain.this.callPreviousFilterWrite(nextEntry, session, writeRequest);
                }

                public void filterClose(IoSession session) {
                    EntryImpl nextEntry = EntryImpl.this.prevEntry;
                    AbstractIoFilterChain.this.callPreviousFilterClose(nextEntry, session);
                }
            };
        }

        public String getName() {
            return this.name;
        }

        public IoFilter getFilter() {
            return this.filter;
        }

        public IoFilter.NextFilter getNextFilter() {
            return this.nextFilter;
        }

        public String toString() {
            return "(" + this.getName() + ':' + this.filter + ')';
        }
    }

    private static class TailFilter
    extends IoFilterAdapter {
        private TailFilter() {
        }

        public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
            session.getHandler().sessionCreated(session);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
            try {
                session.getHandler().sessionOpened(session);
            }
            finally {
                ConnectFuture future = (ConnectFuture)session.removeAttribute(CONNECT_FUTURE);
                if (future != null) {
                    future.setSession(session, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
            try {
                session.getHandler().sessionClosed(session);
            }
            finally {
                session.getFilterChain().clear();
            }
        }

        public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
            session.getHandler().sessionIdle(session, status);
        }

        public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) throws Exception {
            session.getHandler().exceptionCaught(session, cause);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
            try {
                session.getHandler().messageReceived(session, message);
            }
            finally {
                ByteBufferUtil.releaseIfPossible(message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
            try {
                session.getHandler().messageSent(session, message);
            }
            finally {
                ByteBufferUtil.releaseIfPossible(message);
            }
        }

        public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, IoFilter.WriteRequest writeRequest) throws Exception {
            nextFilter.filterWrite(session, writeRequest);
        }

        public void filterClose(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
            nextFilter.filterClose(session);
        }
    }

    private class HeadFilter
    extends IoFilterAdapter {
        private HeadFilter() {
        }

        public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) {
            nextFilter.sessionCreated(session);
        }

        public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) {
            nextFilter.sessionOpened(session);
        }

        public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) {
            nextFilter.sessionClosed(session);
        }

        public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) {
            nextFilter.sessionIdle(session, status);
        }

        public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) {
            nextFilter.exceptionCaught(session, cause);
        }

        public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) {
            nextFilter.messageReceived(session, message);
        }

        public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, Object message) {
            nextFilter.messageSent(session, message);
        }

        public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, IoFilter.WriteRequest writeRequest) throws Exception {
            if (!session.getTransportType().getEnvelopeType().isAssignableFrom(writeRequest.getMessage().getClass())) {
                throw new IllegalStateException("Write requests must be transformed to " + session.getTransportType().getEnvelopeType() + ": " + writeRequest);
            }
            AbstractIoFilterChain.this.doWrite(session, writeRequest);
        }

        public void filterClose(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
            AbstractIoFilterChain.this.doClose(session);
        }
    }
}

