/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.filter;

import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IdleStatus;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoFilter;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoFilterAdapter;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoSession;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.util.SessionLog;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlacklistFilter
extends IoFilterAdapter {
    private final Set<InetAddress> blacklist = new CopyOnWriteArraySet<InetAddress>();

    public void setBlacklist(InetAddress ... addresses) {
        if (addresses == null) {
            throw new NullPointerException("addresses");
        }
        this.blacklist.clear();
        for (int i = 0; i < addresses.length; ++i) {
            InetAddress addr = addresses[i];
            this.block(addr, "addresses[" + i + ']');
        }
    }

    public void setBlacklist(Collection<InetAddress> addresses) {
        if (addresses == null) {
            throw new NullPointerException("addresses");
        }
        InetAddress[] inetAddresses = new InetAddress[addresses.size()];
        try {
            this.setBlacklist(addresses.toArray(inetAddresses));
        }
        catch (ArrayStoreException ase) {
            IllegalArgumentException iae = new IllegalArgumentException("Collection of addresses must contain only InetAddress instances.");
            iae.initCause(ase);
            throw iae;
        }
    }

    public void block(InetAddress address, String error_string) {
        if (address == null) {
            throw new NullPointerException(error_string);
        }
        this.blacklist.add(address);
    }

    public void block(InetAddress address) {
        this.block(address, "address");
    }

    public void unblock(InetAddress address) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        this.blacklist.remove(address);
    }

    @Override
    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) {
        if (!this.isBlocked(session)) {
            nextFilter.sessionCreated(session);
        } else {
            this.blockSession(session);
        }
    }

    @Override
    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        if (!this.isBlocked(session)) {
            nextFilter.sessionOpened(session);
        } else {
            this.blockSession(session);
        }
    }

    @Override
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        if (!this.isBlocked(session)) {
            nextFilter.sessionClosed(session);
        } else {
            this.blockSession(session);
        }
    }

    @Override
    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
        if (!this.isBlocked(session)) {
            nextFilter.sessionIdle(session, status);
        } else {
            this.blockSession(session);
        }
    }

    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) {
        if (!this.isBlocked(session)) {
            nextFilter.messageReceived(session, message);
        } else {
            this.blockSession(session);
        }
    }

    @Override
    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        if (!this.isBlocked(session)) {
            nextFilter.messageSent(session, message);
        } else {
            this.blockSession(session);
        }
    }

    private void blockSession(IoSession session) {
        SessionLog.info(session, "Remote address in the blacklist; closing.");
        session.close();
    }

    private boolean isBlocked(IoSession session) {
        SocketAddress remoteAddress = session.getRemoteAddress();
        return remoteAddress instanceof InetSocketAddress && this.blacklist.contains(((InetSocketAddress)remoteAddress).getAddress());
    }
}

