/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.filter.codec.support;

import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.ByteBuffer;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.WriteFuture;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.filter.codec.ProtocolEncoderOutput;
import java.util.LinkedList;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleProtocolEncoderOutput
implements ProtocolEncoderOutput {
    protected final Queue<ByteBuffer> bufferQueue = new LinkedList<ByteBuffer>();

    public Queue<ByteBuffer> getBufferQueue() {
        return this.bufferQueue;
    }

    @Override
    public void write(ByteBuffer buf) {
        this.bufferQueue.add(buf);
    }

    @Override
    public void mergeAll() {
        ByteBuffer byteBuffer;
        int sum = 0;
        int size = this.bufferQueue.size();
        if (size < 2) {
            return;
        }
        for (Object e : this.bufferQueue) {
            sum += ((ByteBuffer)e).remaining();
        }
        ByteBuffer newBuf = ByteBuffer.allocate(sum);
        while ((byteBuffer = this.bufferQueue.poll()) != null) {
            newBuf.put(byteBuffer);
            byteBuffer.release();
        }
        newBuf.flip();
        this.bufferQueue.offer(newBuf);
    }

    @Override
    public WriteFuture flush() {
        ByteBuffer buf;
        Queue<ByteBuffer> bufferQueue = this.bufferQueue;
        WriteFuture future = null;
        if (bufferQueue.isEmpty()) {
            return null;
        }
        while ((buf = bufferQueue.poll()) != null) {
            if (!buf.hasRemaining()) continue;
            future = this.doFlush(buf);
        }
        return future;
    }

    protected abstract WriteFuture doFlush(ByteBuffer var1);
}

