/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.transport.socket.nio.support;

import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.ByteBuffer;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoFilter;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoSession;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.support.AbstractIoFilterChain;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.transport.socket.nio.support.DatagramAcceptorDelegate;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.transport.socket.nio.support.DatagramConnectorDelegate;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.transport.socket.nio.support.DatagramService;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.transport.socket.nio.support.DatagramSessionImpl;
import java.util.Queue;

class DatagramFilterChain
extends AbstractIoFilterChain {
    DatagramFilterChain(IoSession parent) {
        super(parent);
    }

    protected void doWrite(IoSession session, IoFilter.WriteRequest writeRequest) {
        DatagramSessionImpl s = (DatagramSessionImpl)session;
        Queue<IoFilter.WriteRequest> writeRequestQueue = s.getWriteRequestQueue();
        ByteBuffer buffer = (ByteBuffer)writeRequest.getMessage();
        buffer.mark();
        int remaining = buffer.remaining();
        if (remaining == 0) {
            s.increaseScheduledWriteRequests();
        } else {
            s.increaseScheduledWriteBytes(buffer.remaining());
        }
        writeRequestQueue.add(writeRequest);
        if (session.getTrafficMask().isWritable()) {
            s.getManagerDelegate().flushSession(s);
        }
    }

    protected void doClose(IoSession session) {
        DatagramSessionImpl s = (DatagramSessionImpl)session;
        DatagramService manager = s.getManagerDelegate();
        if (manager instanceof DatagramConnectorDelegate) {
            manager.closeSession(s);
        } else {
            ((DatagramAcceptorDelegate)manager).getListeners().fireSessionDestroyed(session);
            session.getCloseFuture().setClosed();
        }
    }
}

