/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client;

import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.ConfigClientSetting;
import com.taobao.config.client.ConfigClientTimerService;
import com.taobao.config.client.DefaultSubscriber;
import com.taobao.config.client.LocalConfigInfo;
import com.taobao.config.client.Subscriber;
import com.taobao.config.client.SubscriberRegistrar;
import com.taobao.config.client.bean.ObserverData;
import com.taobao.config.client.utils.IOUtils;
import com.taobao.config.client.utils.JSONUtils;
import com.taobao.config.common.protocol.utils.TransmitUtils;
import com.taobao.middleware.logger.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public final class CachePersist {
    private static final Logger log = ConfigClientLogger.getLogger(CachePersist.class);

    public static List<Object> initialData(String dataId, String groupId, String tenant, String env) {
        groupId = CachePersist.defaultIfNull(groupId);
        tenant = null != tenant ? tenant : "DEFAULT_TENANT";
        File lastCache = CachePersist.latestSnapshot(dataId, groupId, tenant, env, false);
        return null != lastCache ? CachePersist.parse(lastCache) : null;
    }

    public static List<Object> initialData(String dataId, String groupId, String env) {
        return CachePersist.initialData(dataId, groupId, null, env);
    }

    public static Map<String, List<ObserverData>> initialDataWithMeta(String dataId, String groupId, String env) {
        return CachePersist.initialDataWithMeta(dataId, groupId, null, env);
    }

    public static Map<String, List<ObserverData>> initialDataWithMeta(String dataId, String groupId, String tenant, String env) {
        groupId = CachePersist.defaultIfNull(groupId);
        tenant = null != tenant ? tenant : "DEFAULT_TENANT";
        File lastCache = CachePersist.latestSnapshot(dataId, groupId, tenant, env, true);
        return null != lastCache ? CachePersist.parseDataWithMeta(lastCache) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> parse(File dataFile) {
        if (!dataFile.exists()) {
            return null;
        }
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(dataFile);
            String jsonText = IOUtils.toString(fin, "GBK");
            if ("".equals(jsonText)) {
                List<Object> list = Collections.emptyList();
                return list;
            }
            List<Object> list = TransmitUtils.fromJSON(jsonText);
            return list;
        }
        catch (Exception e) {
            log.error("%s", "error when read file: " + dataFile.getAbsolutePath() + ", " + e.toString(), e);
            List<Object> list = null;
            return list;
        }
        finally {
            if (null != fin) {
                try {
                    fin.close();
                }
                catch (Exception e) {
                    log.error("%s", e.toString(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, List<ObserverData>> parseDataWithMeta(File dataFile) {
        if (!dataFile.exists()) {
            return null;
        }
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(dataFile);
            String jsonText = IOUtils.toString(fin, "GBK");
            if ("".equals(jsonText)) {
                Map<String, List<ObserverData>> map = Collections.emptyMap();
                return map;
            }
            Map<String, List<ObserverData>> map = JSONUtils.dataWithMetafromJSON(jsonText);
            return map;
        }
        catch (Exception e) {
            log.error("%s", "error when read file: " + dataFile.getAbsolutePath() + ", " + e.toString(), e);
            Map<String, List<ObserverData>> map = null;
            return map;
        }
        finally {
            if (null != fin) {
                try {
                    fin.close();
                }
                catch (Exception e) {
                    log.error("%s", e.toString(), e);
                }
            }
        }
    }

    public static String defaultIfNull(String group) {
        return null != group ? group : "DEFAULT_GROUP";
    }

    public static void save(String dataId, String groupId, List datas, String env) {
        CachePersist.save(dataId, groupId, "DEFAULT_TENANT", datas, env);
    }

    public static void save(String dataId, String groupId, List datas) {
        CachePersist.save(dataId, groupId, "DEFAULT_TENANT", datas, "DEFAULT_ENV");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(String dataId, String groupId, String tenant, List datas, String env) {
        groupId = CachePersist.defaultIfNull(groupId);
        tenant = null != tenant ? tenant : "DEFAULT_TENANT";
        String jsonText = TransmitUtils.toJSON(datas);
        log.info("########## [snapshot-save] " + LocalConfigInfo.SNAPSHOT_ROOT + File.separator + dataId + ", " + groupId + ", " + tenant);
        if (LocalConfigInfo.IsWindows) {
            try {
                dataId = URLEncoder.encode(dataId, "GBK");
            }
            catch (Exception e) {
                log.error("%s", "Error while encoding file name: " + dataId, e);
            }
        }
        String dataFileStr = MessageFormat.format(LocalConfigInfo.DATA_FILE_PATTERN, env.replaceAll("\\?", "#"), dataId, groupId, tenant);
        File dataFile = new File(dataFileStr);
        Writer fout = null;
        try {
            dataFile.getParentFile().mkdirs();
            dataFile.createNewFile();
            fout = new OutputStreamWriter((OutputStream)new FileOutputStream(dataFile), "GBK");
            fout.write(jsonText);
        }
        catch (IOException e) {
            log.error("%s", e.toString(), e);
        }
        finally {
            if (null != fout) {
                try {
                    fout.close();
                }
                catch (Exception e2) {
                    log.error("%s", e2.toString(), e2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(String dataId, String groupId, String tenant, Map<String, List<ObserverData>> dataGroup, String env) {
        groupId = CachePersist.defaultIfNull(groupId);
        tenant = null != tenant ? tenant : "DEFAULT_TENANT";
        log.info("########## [snapshot-save] " + LocalConfigInfo.SNAPSHOT_ROOT + File.separator + dataId + ", " + groupId + ", " + tenant);
        if (LocalConfigInfo.IsWindows) {
            try {
                dataId = URLEncoder.encode(dataId, "GBK");
            }
            catch (Exception e) {
                log.error("%s", "Error while encoding file name: " + dataId, e);
            }
        }
        String dataFileStr = MessageFormat.format(LocalConfigInfo.META_DATA_FILE_PATTERN, env.replaceAll("\\?", "#"), dataId, groupId, tenant);
        File dataFile = new File(dataFileStr);
        BufferedWriter bufferedWriter = null;
        try {
            dataFile.getParentFile().mkdirs();
            dataFile.createNewFile();
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dataFile), "GBK"), ConfigClientSetting.getPersistBufferSize());
            if (dataGroup == null || dataGroup.isEmpty()) {
                bufferedWriter.write("\"\"");
                return;
            }
            bufferedWriter.write("{");
            int entryIndex = 0;
            for (Map.Entry<String, List<ObserverData>> entry : dataGroup.entrySet()) {
                String key = entry.getKey();
                bufferedWriter.write("\"");
                bufferedWriter.write(key);
                bufferedWriter.write("\":[\r\n");
                List<ObserverData> obDatas = entry.getValue();
                if (obDatas != null) {
                    for (int i = 0; i < obDatas.size(); ++i) {
                        ObserverData observerData = obDatas.get(i);
                        bufferedWriter.write("{");
                        if (observerData.getAppName() != null) {
                            bufferedWriter.write("\"appName\":\"");
                            bufferedWriter.write(observerData.getAppName());
                            bufferedWriter.write("\",");
                        }
                        if (observerData.getMachineGroup() != null) {
                            bufferedWriter.write("\"machineGroup\":\"");
                            bufferedWriter.write(observerData.getMachineGroup());
                            bufferedWriter.write("\",");
                        }
                        if (observerData.getUnit() != null) {
                            bufferedWriter.write("\"unit\":\"");
                            bufferedWriter.write(observerData.getUnit());
                            bufferedWriter.write("\",");
                        }
                        if (observerData.getSite() != null) {
                            bufferedWriter.write("\"site\":\"");
                            bufferedWriter.write(observerData.getSite());
                            bufferedWriter.write("\",");
                        }
                        if (observerData.getIpGroup() != null) {
                            bufferedWriter.write("\"ipGroup\":\"");
                            bufferedWriter.write(observerData.getIpGroup());
                            bufferedWriter.write("\",\r\n");
                        }
                        bufferedWriter.write("\"data\":\"");
                        bufferedWriter.write((String)observerData.getData());
                        if (i != obDatas.size() - 1) {
                            bufferedWriter.write("\"},\r\n");
                            continue;
                        }
                        bufferedWriter.write("\"}\r\n");
                    }
                }
                if (entryIndex != dataGroup.size() - 1) {
                    bufferedWriter.write("],\r\n");
                } else {
                    bufferedWriter.write("]\r\n");
                }
                ++entryIndex;
            }
            bufferedWriter.write("}");
        }
        catch (IOException e) {
            log.error("%s", e.toString(), e);
        }
        finally {
            if (null != bufferedWriter) {
                try {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
                catch (Exception e2) {
                    log.error("%s", e2.toString(), e2);
                }
            }
        }
    }

    public static List<File> getSnapshots(String dataId, String groupId) {
        return CachePersist.getSnapshots(dataId, groupId, "DEFAULT_ENV", false);
    }

    public static List<File> getSnapshots(String dataId, String groupId, String env, boolean isMetaData) {
        return CachePersist.getSnapshots(dataId, groupId, "DEFAULT_TENANT", env, isMetaData);
    }

    public static List<File> getSnapshots(String dataId, final String groupId, final String tenant, String env, final String fileEnd) {
        File dataIdDir;
        File[] snapshots;
        if (LocalConfigInfo.IsWindows) {
            try {
                dataId = URLEncoder.encode(dataId, "GBK");
            }
            catch (Exception e) {
                log.error("%s", "Error while decoding file name: " + dataId, e);
            }
        }
        return null == (snapshots = (dataIdDir = new File(LocalConfigInfo.SNAPSHOT_ROOT + File.separator + env.replaceAll("\\?", "#"), dataId)).listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().startsWith(groupId + "-" + tenant + fileEnd);
            }
        })) ? Collections.emptyList() : new ArrayList<File>(Arrays.asList(snapshots));
    }

    public static List<File> getSnapshots(String dataId, String groupId, String tenant, String env, boolean isMetaData) {
        String fileEnd = isMetaData ? "-withMeta.dat" : ".dat";
        return CachePersist.getSnapshots(dataId, groupId, tenant, env, fileEnd);
    }

    public static File latestSnapshot(String dataId, String groupId) {
        return CachePersist.latestSnapshot(dataId, groupId, "DEFAULT_TENANT", "DEFAULT_ENV", false);
    }

    public static File latestSnapshot(String dataId, String groupId, boolean isMetaData) {
        return CachePersist.latestSnapshot(dataId, groupId, "DEFAULT_TENANT", "DEFAULT_ENV", isMetaData);
    }

    public static File latestSnapshot(String dataId, String groupId, String env, boolean isMetaData) {
        return CachePersist.latestSnapshot(dataId, groupId, "DEFAULT_TENANT", env, isMetaData);
    }

    public static File latestSnapshot(String dataId, String groupId, String tenant, String env, String fileEnd) {
        List<File> snapshots = CachePersist.getSnapshots(dataId, groupId, tenant, env, fileEnd);
        if (snapshots.isEmpty()) {
            return null;
        }
        long latestTime = -1L;
        File latestSnapshot = null;
        for (File snapshot : snapshots) {
            long time = snapshot.lastModified();
            if (time <= latestTime) continue;
            latestTime = time;
            latestSnapshot = snapshot;
        }
        return latestSnapshot;
    }

    public static File latestSnapshot(String dataId, String groupId, String tenant, String env, boolean isMetaData) {
        String fileEnd = isMetaData ? "-withMeta.dat" : ".dat";
        return CachePersist.latestSnapshot(dataId, groupId, tenant, env, fileEnd);
    }

    public static boolean isNewSnapshots(String dataId, String groupId, String tenant, String env) {
        File file = CachePersist.latestSnapshot(dataId, groupId, tenant, env, "");
        String name = file.getName();
        return name.endsWith("-withMeta.dat");
    }

    static void clear() {
        File root = new File(LocalConfigInfo.SNAPSHOT_ROOT);
        File[] sub = root.listFiles();
        if (null == sub) {
            return;
        }
        for (File dataIdDir : sub) {
            if (!dataIdDir.isDirectory()) continue;
            for (File dataFile : dataIdDir.listFiles()) {
                dataFile.delete();
            }
            dataIdDir.delete();
        }
    }

    static {
        if (!ConfigClientSetting.isNotRollSnapshot()) {
            Calendar now = Calendar.getInstance();
            Calendar next = Calendar.getInstance();
            next.set(11, 3);
            Random random = new Random();
            int randomMins = random.nextInt(60);
            next.set(12, randomMins);
            next.set(13, 0);
            next.roll(5, 1);
            log.info("[RollSnapshot-init] 03:" + randomMins);
            long delayMs = next.getTimeInMillis() - now.getTimeInMillis();
            ConfigClientTimerService.timer.scheduleAtFixedRate(new RollSnapshotTask(), delayMs, TimeUnit.DAYS.toMillis(1L), TimeUnit.MILLISECONDS);
        }
        if (ConfigClientSetting.isTimerCachePersist()) {
            ConfigClientTimerService.timer.scheduleWithFixedDelay(new TimerCachePersistTask(), ConfigClientSetting.getTimerInitDelayMins(), ConfigClientSetting.getTimerCycleMins(), TimeUnit.MINUTES);
        }
    }

    static class RollSnapshotTask
    implements Runnable {
        RollSnapshotTask() {
        }

        @Override
        public void run() {
            if (ConfigClientSetting.isNotRollSnapshot()) {
                return;
            }
            for (Subscriber sub : SubscriberRegistrar.getSubs()) {
                String dataId = sub.getRegistration().getDataId();
                String groupId = sub.getRegistration().getGroup();
                String tenant = sub.getRegistration().getTenant();
                String env = "";
                if (sub instanceof DefaultSubscriber) {
                    env = ((DefaultSubscriber)sub).serverMgr.getEnv();
                }
                boolean isExistSubMetaDataObserver = ((DefaultSubscriber)sub).isExistSubMetaDataObserver;
                String snapshotPath = null;
                try {
                    boolean isNew = CachePersist.isNewSnapshots(dataId, groupId, tenant, env);
                    snapshotPath = isNew ? MessageFormat.format(LocalConfigInfo.META_DATA_FILE_PATTERN, env.replaceAll("\\?", "#"), dataId, groupId, tenant) : MessageFormat.format(LocalConfigInfo.DATA_FILE_PATTERN, env.replaceAll("\\?", "#"), dataId, groupId, tenant);
                    String renamePath = snapshotPath + "." + RollSnapshotTask.calculateSuffix();
                    File snapshotFile = new File(snapshotPath);
                    snapshotFile.renameTo(new File(renamePath));
                    IOUtils.copyFile(renamePath, snapshotPath);
                    RollSnapshotTask.keepLatest8(dataId, groupId, tenant, env, null);
                }
                catch (Exception ioe) {
                    log.error("%s", "[roll-snapshot] fail to roll. dataId: " + dataId + ", groupId: " + groupId, ioe);
                }
            }
        }

        static void keepLatest8(String dataId, String groupId, String tenant, String env, Boolean isMetaData) {
            List<File> snapshots = null;
            if (isMetaData == null) {
                snapshots = CachePersist.getSnapshots(dataId, groupId, tenant, env, false);
                snapshots.addAll(CachePersist.getSnapshots(dataId, groupId, tenant, env, true));
            } else {
                snapshots = CachePersist.getSnapshots(dataId, groupId, tenant, env, isMetaData);
            }
            int count = 8;
            if (snapshots.size() <= 8) {
                return;
            }
            Collections.sort(snapshots, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return (int)Math.signum(o1.lastModified() - o2.lastModified());
                }
            });
            while (snapshots.size() > 8) {
                snapshots.remove(0).delete();
            }
        }

        static String calculateSuffix() {
            SimpleDateFormat fileSuffix = new SimpleDateFormat("yyyy-MM-dd_HH:mm");
            return fileSuffix.format(new Date());
        }
    }

    static class TimerCachePersistTask
    implements Runnable {
        TimerCachePersistTask() {
        }

        @Override
        public void run() {
            if (ConfigClientSetting.isNotCachePersist()) {
                log.info("[timer-cache-persist] isNotCachePersist is true, timer-cache not start");
                return;
            }
            log.info("[timer-cache-persist] persist start");
            long startTime = System.currentTimeMillis();
            for (Subscriber sub : SubscriberRegistrar.getSubs()) {
                String dataId = sub.getRegistration().getDataId();
                String groupId = sub.getRegistration().getGroup();
                String tenant = sub.getRegistration().getTenant();
                String env = "";
                Map<String, List<ObserverData>> dataMap = null;
                try {
                    if (sub instanceof DefaultSubscriber) {
                        DefaultSubscriber defaultSubscriber = (DefaultSubscriber)sub;
                        env = defaultSubscriber.serverMgr.getEnv();
                        dataMap = defaultSubscriber.getObserverDataGroups();
                    }
                    if (dataMap != null) {
                        CachePersist.save(dataId, groupId, tenant, dataMap, env);
                    }
                    if (ConfigClientSetting.getTimerCycleTime() == 0L) continue;
                    Thread.sleep(ConfigClientSetting.getTimerCycleTime());
                }
                catch (Exception ioe) {
                    log.error("%s", "[timer-snapshot] fail to cache. dataId: " + dataId + ", groupId: " + groupId, ioe);
                }
            }
            log.info("[timer-cache-persist] persist end, time is " + (System.currentTimeMillis() - startTime) + "ms");
        }
    }
}

