/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client;

import com.taobao.config.client.ConfigClientSetting;
import com.taobao.config.client.LocalConfigInfo;
import com.taobao.config.client.utils.StringUtils;
import com.taobao.middleware.logger.Level;
import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.LoggerFactory;
import com.taobao.middleware.logger.support.LoggerHelper;

public class ConfigClientLogger {
    private static Logger log = LoggerFactory.getLogger("ConfigClientLogger");
    static int JM_CC_LOG_RETAIN_COUNT = 6;
    static String JM_LOG_FILE_SIZE = "200MB";
    static int JM_OTHERS_LOG_RETAIN_COUNT = 2;

    public static Logger getLog() {
        return log;
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz);
    }

    public static Logger getJesusislordLogger() {
        return LoggerFactory.getLogger("jesusislord");
    }

    static {
        int fileSize = 200;
        try {
            String tmp = System.getProperty("JM.LOG.RETAIN.COUNT", "6");
            JM_CC_LOG_RETAIN_COUNT = Integer.parseInt(tmp);
            JM_LOG_FILE_SIZE = System.getProperty("JM.LOG.FILE.SIZE", "200MB");
            fileSize = StringUtils.getNumber(JM_LOG_FILE_SIZE);
            log.info("JM_CC_LOG_RETAIN_COUNT:" + JM_CC_LOG_RETAIN_COUNT + ", JM_LOG_FILE_SIZE:" + JM_LOG_FILE_SIZE);
        }
        catch (NumberFormatException e) {
            log.error("invalid value settings for JM.LOG.RETAIN.COUNT or JM.LOG.FILE.SIZE", "configclient", e);
        }
        String fileSizeUnit = JM_LOG_FILE_SIZE.substring(JM_LOG_FILE_SIZE.length() - 2);
        int configclientFileSize = (int)((double)fileSize * 0.7 / (double)JM_CC_LOG_RETAIN_COUNT);
        int remotingFileSize = (int)((double)fileSize * 0.1 / (double)JM_OTHERS_LOG_RETAIN_COUNT);
        int jesusislordFileSize = (int)((double)fileSize * 0.2 / (double)JM_OTHERS_LOG_RETAIN_COUNT);
        LoggerHelper.setPattern("configclient", "%d{yyyy-MM-dd HH:mm:ss.SSS}|%p|%m%n");
        Logger clientLogger = LoggerFactory.getLogger("com.taobao.config.client");
        clientLogger.activateAppenderWithSizeRolling("configclient", "config-client.log", "GBK", configclientFileSize + fileSizeUnit, JM_CC_LOG_RETAIN_COUNT - 1);
        clientLogger.setLevel(Level.INFO);
        clientLogger.setAdditivity(false);
        Logger commonLogger = LoggerFactory.getLogger("com.taobao.config.common");
        commonLogger.activateAppenderWithSizeRolling("configclient", "config-common.log", "GBK", remotingFileSize + fileSizeUnit, JM_CC_LOG_RETAIN_COUNT - 1);
        commonLogger.setLevel(Level.INFO);
        commonLogger.setAdditivity(false);
        Logger remotingLogger = LoggerFactory.getLogger("com.taobao.remoting");
        remotingLogger.activateAppenderWithSizeRolling("configclient", "remoting.log", "GBK", remotingFileSize + fileSizeUnit, JM_OTHERS_LOG_RETAIN_COUNT - 1);
        remotingLogger.setLevel(Level.INFO);
        remotingLogger.setAdditivity(false);
        Logger minaLogger = LoggerFactory.getLogger("com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina");
        minaLogger.activateAppender(remotingLogger);
        Logger jesusislordLogger = LoggerFactory.getLogger("jesusislord");
        jesusislordLogger.activateAppenderWithSizeRolling("configclient", "jesusislord.log", "GBK", jesusislordFileSize + fileSizeUnit, JM_OTHERS_LOG_RETAIN_COUNT - 1);
        jesusislordLogger.setLevel(Level.INFO);
        jesusislordLogger.setAdditivity(false);
        clientLogger.info("ConfigClient Version is " + LocalConfigInfo.getVersion());
        clientLogger.info("endpoint is " + ConfigClientSetting.getAddressServerDomain() + ":" + ConfigClientSetting.getAddressServerPort());
        clientLogger.info("NotCachePersist is " + ConfigClientSetting.isNotCachePersist() + ", NotRollSnapshot is " + ConfigClientSetting.isNotRollSnapshot() + ", TimerCachePersist is " + ConfigClientSetting.isTimerCachePersist() + ", PersistBufferSize is " + ConfigClientSetting.getPersistBufferSize() + ", TimerCycleTime is " + ConfigClientSetting.getTimerCycleTime() + ", TimerCycleMins is " + ConfigClientSetting.getTimerCycleMins() + ", TimerInitDelayMins is " + ConfigClientSetting.getTimerInitDelayMins());
    }
}

