/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client;

import com.taobao.config.client.ConfigClientRegistration;
import com.taobao.config.client.InstanceIdKeeper;
import com.taobao.config.client.bean.InstanceMetaData;
import com.taobao.config.client.services.ConfigClientConstants;
import java.io.Serializable;

class DataClientRegistration
extends ConfigClientRegistration {
    private static final InstanceIdKeeper instanceIdKeeper = new InstanceIdKeeper();
    private final String dataId;
    private final String datumId;
    private InstanceMetaData instanceMetaData;

    public String getDataId() {
        return this.dataId;
    }

    public String getDatumId() {
        return this.datumId;
    }

    public void setGroup(String group) {
        this.setAttribute("!Group", (Serializable)((Object)group));
    }

    public String getGroup() {
        String group = this.getStringAttribute("!Group");
        return null != group ? group : "DEFAULT_GROUP";
    }

    public void setScope(ConfigClientConstants.SCOPE scope) {
        this.setAttribute("!Scope", (Serializable)((Object)scope.toString()));
    }

    public String getScope() {
        String scope = this.getStringAttribute("!Scope");
        return null != scope ? scope : ConfigClientConstants.SCOPE.global.toString();
    }

    public InstanceMetaData getInstanceMetaData() {
        return this.instanceMetaData;
    }

    public void setInstanceMetaData(InstanceMetaData instanceMetaData) {
        this.instanceMetaData = instanceMetaData;
    }

    public void setTenant(String tenant) {
        this.setAttribute("!Tenant", (Serializable)((Object)tenant));
    }

    public String getTenant() {
        String tenant = this.getStringAttribute("!Tenant");
        return null != tenant ? tenant : "DEFAULT_TENANT";
    }

    protected DataClientRegistration(String clientName, String dataId, String datumId) {
        super(clientName, instanceIdKeeper.getNewInstanceId(clientName));
        if (dataId == null) {
            throw new IllegalArgumentException("dataId is null.");
        }
        this.dataId = dataId;
        this.datumId = datumId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        return 31 * (31 + this.dataId.hashCode()) + (this.datumId == null ? 0 : this.datumId.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataClientRegistration)) {
            return false;
        }
        DataClientRegistration other = (DataClientRegistration)obj;
        if (!this.dataId.equals(other.dataId)) {
            return false;
        }
        return !(this.datumId == null ? other.datumId != null : !this.datumId.equals(other.datumId));
    }
}

