/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client;

import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.ConfigClientPerfCtrl;
import com.taobao.config.client.ConfigClientTimerService;
import com.taobao.config.client.DefaultPublisher;
import com.taobao.config.client.DefaultSubscriber;
import com.taobao.config.client.LocalConfigInfo;
import com.taobao.config.client.PublisherRegistrar;
import com.taobao.config.client.PublisherRegistration;
import com.taobao.config.client.ServerListManagerFactory;
import com.taobao.config.client.SubscriberRegistrar;
import com.taobao.middleware.logger.Logger;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class DumpServiceStatus {
    private static Logger jesusislordLogger = ConfigClientLogger.getJesusislordLogger();
    private static String PUBLISHER_PREFIX = "|cspublisher";
    private static String SUBSCRIBER_PREFIX = "|cssubscriber";
    private static String CONNECION_STATUS = "|csreconnected";
    private static final String MESSAGG_SEPARATOR = "|";
    private static DumpServiceStatus dumpServiceStatus = new DumpServiceStatus();

    public static DumpServiceStatus getInstance() {
        return dumpServiceStatus;
    }

    private DumpServiceStatus() {
    }

    public void start() {
        ConfigClientTimerService.timer.scheduleWithFixedDelay(new DumpWorker(), 1L, 30L, TimeUnit.MINUTES);
    }

    private class DumpWorker
    implements Runnable {
        private DumpWorker() {
        }

        @Override
        public void run() {
            if (ConfigClientPerfCtrl.isDumpServiceStatus()) {
                try {
                    jesusislordLogger.info("start dump service status... version=" + LocalConfigInfo.getVersion());
                    int pubCount = 0;
                    int synchronizedPubCount = 0;
                    int unsynchronizedPubCount = 0;
                    int subCount = 0;
                    int getAddressSubCount = 0;
                    int ungetAddressSubCount = 0;
                    Iterator<DefaultPublisher<?>> publisherIterator = PublisherRegistrar.publisherIterator();
                    while (publisherIterator.hasNext()) {
                        DefaultPublisher<?> defaultPublisher = publisherIterator.next();
                        StringBuffer sbBuffer = new StringBuffer(PUBLISHER_PREFIX).append(DumpServiceStatus.MESSAGG_SEPARATOR);
                        sbBuffer.append(defaultPublisher.getDataId()).append(DumpServiceStatus.MESSAGG_SEPARATOR);
                        sbBuffer.append(((PublisherRegistration)defaultPublisher.getRegistration()).getGroup()).append(DumpServiceStatus.MESSAGG_SEPARATOR);
                        sbBuffer.append(defaultPublisher.getEnv()).append(DumpServiceStatus.MESSAGG_SEPARATOR);
                        boolean isSynchronized = defaultPublisher.isSynchronized();
                        sbBuffer.append(isSynchronized);
                        if (isSynchronized) {
                            ++synchronizedPubCount;
                            jesusislordLogger.info(sbBuffer.toString());
                        } else {
                            ++unsynchronizedPubCount;
                            jesusislordLogger.error("", sbBuffer.toString());
                        }
                        ++pubCount;
                    }
                    Iterator<DefaultSubscriber> subsriberIterator = SubscriberRegistrar.subscriberIterator();
                    while (subsriberIterator.hasNext()) {
                        DefaultSubscriber defaultSubscriber = subsriberIterator.next();
                        StringBuffer sbBuffer = new StringBuffer(SUBSCRIBER_PREFIX).append(DumpServiceStatus.MESSAGG_SEPARATOR);
                        sbBuffer.append(defaultSubscriber.getDataId()).append(DumpServiceStatus.MESSAGG_SEPARATOR);
                        sbBuffer.append(defaultSubscriber.getRegistration().getGroup()).append(DumpServiceStatus.MESSAGG_SEPARATOR);
                        int dataSize = defaultSubscriber.dataSize();
                        sbBuffer.append(dataSize);
                        if (dataSize > 0) {
                            ++getAddressSubCount;
                            jesusislordLogger.info(sbBuffer.toString());
                        } else {
                            ++ungetAddressSubCount;
                            jesusislordLogger.error("", sbBuffer.toString());
                        }
                        ++subCount;
                    }
                    jesusislordLogger.info("multiConnections=" + ConfigClientPerfCtrl.isMultiConnections());
                    for (String connectionStatus : ServerListManagerFactory.dumpConnectionStatus()) {
                        StringBuffer sbBuffer = new StringBuffer(CONNECION_STATUS);
                        sbBuffer.append(DumpServiceStatus.MESSAGG_SEPARATOR);
                        sbBuffer.append(connectionStatus);
                        jesusislordLogger.info(sbBuffer.toString());
                    }
                    jesusislordLogger.info("multiConnections=" + ConfigClientPerfCtrl.isMultiConnections());
                    jesusislordLogger.info(ServerListManagerFactory.dumpDetail());
                    jesusislordLogger.info("dump service status: pubCount={},syncPubCount={},unSyncPubCount={},subCount={},getAddressSubCount={},unGetAddressSubCount={}", pubCount, synchronizedPubCount, unsynchronizedPubCount, subCount, getAddressSubCount, ungetAddressSubCount);
                }
                catch (Exception e) {
                    jesusislordLogger.error("dump-status-error", e.getMessage());
                }
            }
        }
    }
}

