/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client;

import com.taobao.config.client.ConfigClientLogger;
import com.taobao.middleware.logger.Logger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class EventDispatcher {
    protected static final Logger log = ConfigClientLogger.getLogger(EventDispatcher.class);
    static final Map<Class<? extends Event>, CopyOnWriteArrayList<EventListener>> listenerMap = new HashMap<Class<? extends Event>, CopyOnWriteArrayList<EventListener>>();

    public static void addEventListener(EventListener listener) {
        for (Class<? extends Event> type : listener.interest()) {
            EventDispatcher.getListenerList(type).addIfAbsent(listener);
        }
    }

    public static void fireEvent(Event event) {
        if (null == event) {
            return;
        }
        for (Event implyEvent : event.implyEvents()) {
            try {
                if (event == implyEvent) continue;
                EventDispatcher.fireEvent(implyEvent);
            }
            catch (Exception e) {
                log.error("%s", e.toString(), e);
            }
        }
        for (EventListener listener : EventDispatcher.getListenerList(event.getClass())) {
            try {
                listener.onEvent(event);
            }
            catch (Exception e) {
                log.error("%s", e.toString(), e);
            }
        }
    }

    static synchronized CopyOnWriteArrayList<EventListener> getListenerList(Class<? extends Event> eventType) {
        CopyOnWriteArrayList<EventListener> listeners = listenerMap.get(eventType);
        if (null == listeners) {
            listeners = new CopyOnWriteArrayList();
            listenerMap.put(eventType, listeners);
        }
        return listeners;
    }

    public static abstract class EventListener {
        public EventListener() {
            EventDispatcher.addEventListener(this);
        }

        public abstract List<Class<? extends Event>> interest();

        public abstract void onEvent(Event var1);
    }

    public static abstract class Event {
        protected List<Event> implyEvents() {
            return Collections.EMPTY_LIST;
        }
    }
}

