/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client;

import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.ConfigClientTimerService;
import com.taobao.config.client.EventDispatcher;
import com.taobao.config.client.Events;
import com.taobao.config.client.LocalConfigInfo;
import com.taobao.config.client.failover.FailoverModeListener;
import com.taobao.middleware.logger.Logger;
import java.io.File;
import java.util.concurrent.TimeUnit;

public class RunMode {
    private static final Logger log = ConfigClientLogger.getLogger(RunMode.class);
    public static final int NORMAL = 1;
    public static final int FAILOVER = 2;
    private static volatile int runMode = 1;

    public static boolean isNormalMode() {
        return 1 == runMode;
    }

    public static boolean isFailoverMode() {
        return 2 == runMode;
    }

    static void checkRunMode() {
        boolean isFailOver = new File(LocalConfigInfo.FAILOVER_TRIGGER_PATH).exists();
        if (RunMode.isFailoverMode() != isFailOver) {
            runMode = isFailOver ? 2 : 1;
            EventDispatcher.fireEvent(new Events.RunModeChangeEvent());
        }
    }

    static {
        new FailoverModeListener();
        ConfigClientTimerService.timer.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    RunMode.checkRunMode();
                }
                catch (Throwable ex) {
                    log.error("%s", "error when check run mode: " + ex.toString(), ex);
                }
            }
        }, 0L, 5L, TimeUnit.SECONDS);
    }
}

