/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client;

import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.ServerListManager;
import com.taobao.config.common.ConfigServerURL;
import com.taobao.middleware.logger.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class ServerAddressIterator
implements Iterator<ConfigServerURL> {
    static final Logger log = ConfigClientLogger.getLogger(ServerListManager.class);
    final List<ConfigServerURL> sorted = new ArrayList<ConfigServerURL>();
    final Iterator<ConfigServerURL> iter;

    public ServerAddressIterator(List<String> source) {
        for (String address : source) {
            try {
                this.sorted.add(new ConfigServerURL(address));
            }
            catch (Exception e) {
                log.error("%s", "serverAddressIP:" + address + " error on new ConfigServerURL, ignore this ip", e);
            }
        }
        Collections.shuffle(this.sorted);
        this.iter = this.sorted.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public ConfigServerURL next() {
        return this.iter.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

