/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client;

import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.DefaultSubscriber;
import com.taobao.config.client.EventDispatcher;
import com.taobao.config.client.Events;
import com.taobao.config.client.Initialization;
import com.taobao.config.client.Subscriber;
import com.taobao.config.client.SubscriberRegistration;
import com.taobao.middleware.logger.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SubscriberRegistrar {
    static final Logger log = ConfigClientLogger.getLogger(SubscriberRegistrar.class);
    static final ConcurrentHashMap<String, DefaultSubscriber> clients = new ConcurrentHashMap();

    public static synchronized Subscriber register(SubscriberRegistration registration) {
        if (null == registration) {
            throw new IllegalArgumentException("registration is null");
        }
        String clientId = registration.getClientId();
        DefaultSubscriber subscriber = SubscriberRegistrar.findExitSub(registration);
        if (null != subscriber) {
            log.info("########## [reuse-subscriber] " + subscriber);
            return subscriber;
        }
        try {
            subscriber = new DefaultSubscriber(registration);
            clients.put(clientId, subscriber);
            EventDispatcher.fireEvent(new Events.AddSubscriberEvent(subscriber));
        }
        catch (Exception e) {
            log.error("%s", "[Internal] Exception in registering subscriber: ", e);
        }
        return subscriber;
    }

    public static boolean unregister(Subscriber subscriber) {
        if (null == subscriber) {
            throw new IllegalArgumentException("subscriber is null");
        }
        log.info("[Registrar] Unregister " + subscriber.getRegistration());
        try {
            ((DefaultSubscriber)subscriber).unregister();
            clients.remove(subscriber.getClientId());
            return true;
        }
        catch (Exception e) {
            log.error("%s", "[Internal] Exception in unregistering subscriber: ", e);
            return false;
        }
    }

    public static Iterator<DefaultSubscriber> subscriberIterator() {
        return clients.values().iterator();
    }

    private static DefaultSubscriber findExitSub(SubscriberRegistration registration) {
        String dataId = registration.getDataId();
        String groupId = registration.getGroup();
        String tenant = registration.getTenant();
        String serverEnv = (String)registration.getLocalAttribute("!Server");
        String centerEnv = (String)registration.getLocalAttribute("!Center");
        List<DefaultSubscriber> existSubs = SubscriberRegistrar.findSubs(dataId, groupId, tenant);
        for (DefaultSubscriber subscriber : existSubs) {
            String subCenterEnv = (String)subscriber.getRegistration().getLocalAttribute("!Center");
            String subServerEnv = (String)subscriber.getRegistration().getLocalAttribute("!Server");
            if (null == serverEnv && centerEnv == null && null == subCenterEnv && null == subServerEnv) {
                return subscriber;
            }
            if (null != centerEnv && centerEnv.equals(subCenterEnv)) {
                return subscriber;
            }
            if (null == serverEnv || !serverEnv.equals(subServerEnv)) continue;
            return subscriber;
        }
        return null;
    }

    private static List<DefaultSubscriber> findSubs(String dataId, String groupId, String tenant) {
        LinkedList<DefaultSubscriber> result = new LinkedList<DefaultSubscriber>();
        for (DefaultSubscriber subscriber : clients.values()) {
            if (!dataId.equals(subscriber.getDataId()) || !groupId.equals(subscriber.getRegistration().getGroup()) || !tenant.equals(subscriber.getRegistration().getTenant())) continue;
            result.add(subscriber);
        }
        return result;
    }

    public static DefaultSubscriber find(String clientId) {
        return clients.get(clientId);
    }

    public static List<DefaultSubscriber> findByDataId(String dataId) {
        LinkedList<DefaultSubscriber> result = new LinkedList<DefaultSubscriber>();
        for (DefaultSubscriber subscriber : clients.values()) {
            if (!subscriber.getDataId().equals(dataId)) continue;
            result.add(subscriber);
        }
        return result;
    }

    public static List<String> findClientIdsByDataId(String dataId) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, DefaultSubscriber> entry : clients.entrySet()) {
            Subscriber subscriber = entry.getValue();
            if (!subscriber.getDataId().equals(dataId)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    static boolean remove(Subscriber subscriber) {
        return clients.remove(subscriber.getClientId()) != null;
    }

    public static List<Subscriber> getSubs() {
        ArrayList<Subscriber> subs = new ArrayList<Subscriber>(clients.size());
        subs.addAll(clients.values());
        return subs;
    }

    public static Collection<DefaultSubscriber> AllDefaultSubs() {
        return Collections.unmodifiableCollection(clients.values());
    }

    static {
        new Initialization();
    }
}

