/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client.failover;

import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.ConfigClientTimerService;
import com.taobao.config.client.DefaultSubscriber;
import com.taobao.config.client.RunMode;
import com.taobao.config.client.Subscriber;
import com.taobao.config.client.failover.FailoverDataParser;
import com.taobao.middleware.logger.Logger;
import java.util.List;
import java.util.concurrent.TimeUnit;

class CheckFailoverForUpdateTask
implements Runnable {
    private static final Logger log = ConfigClientLogger.getLogger(CheckFailoverForUpdateTask.class);
    public static final long INTERVAL_SECONDS = 5L;
    final DefaultSubscriber subscriber;
    long lastModified = -1L;

    public static void createAndSchedule(Subscriber sub) {
        CheckFailoverForUpdateTask task = new CheckFailoverForUpdateTask(sub);
        ConfigClientTimerService.timer.scheduleWithFixedDelay(task, 0L, 5L, TimeUnit.SECONDS);
    }

    private CheckFailoverForUpdateTask(Subscriber subscriber) {
        this.subscriber = (DefaultSubscriber)subscriber;
    }

    @Override
    public void run() {
        String groupId;
        if (RunMode.isNormalMode()) {
            log.info(this.getClass().getName() + " exit: " + this.subscriber.toString());
            throw new RuntimeException("change to normal mode");
        }
        String dataId = this.subscriber.getDataId();
        Long lastModified = FailoverDataParser.getLastModified(dataId, groupId = this.subscriber.getRegistration().getGroup());
        if (null == lastModified) {
            log.warn("########## [failover-data-not-found] dataId: " + dataId + ", groupId: " + groupId);
            return;
        }
        if (lastModified != this.lastModified) {
            this.lastModified = lastModified;
            List<Object> data = FailoverDataParser.getFailoverData(dataId, groupId);
            if (null != data) {
                log.warn("########## [check-failover-data] set subscriber data: " + this.subscriber + ", " + data);
                this.subscriber.update(this.subscriber.revision().getUpdatedRevision(), data, null);
            }
        }
    }
}

