/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client.pandolet;

import com.taobao.config.client.LocalConfigInfo;
import com.taobao.config.client.services.ConfigClientService;
import com.taobao.middleware.logger.support.LoggerHelper;
import com.taobao.pandora.pandolet.annotation.Health;
import com.taobao.pandora.pandolet.annotation.Parameter;
import com.taobao.pandora.pandolet.annotation.Service;
import com.taobao.pandora.pandolet.domain.PandoletSupport;

public class ConfigClientPandolet
extends PandoletSupport {
    public String getName() {
        return "ConfigClientPandolet";
    }

    @Service(description="get all connections to server by 9600 port")
    public String clientConnections() {
        return ConfigClientService.getClientConnections();
    }

    @Service
    public String pubInfo() {
        return ConfigClientService.getAllPubInfo();
    }

    @Service(description="sub dataIds")
    public String subInfo() {
        return ConfigClientService.getAllsubInfo();
    }

    @Service
    public String subData(@Parameter(name="dataId") String dataId, @Parameter(name="groupName") String groupName) {
        return ConfigClientService.getSubData(dataId, groupName);
    }

    @Service
    public String subObserverData(@Parameter(name="dataId") String dataId, @Parameter(name="groupName") String groupName) {
        return ConfigClientService.getSubObserverData(dataId, groupName);
    }

    @Service
    public String getWeightValue(@Parameter(name="dataId") String dataId, @Parameter(name="groupName") String groupName) {
        return ConfigClientService.getWeightValue(dataId, groupName);
    }

    @Health
    @Service(description="health check", returnValue="UP/DOWN/OUT_OF_SERVICE/UNKNOWN")
    public String healthStatus() {
        return ConfigClientService.getHealthStatus();
    }

    @Service(description="all env serverlist")
    public String allEnvServerlist() {
        return ConfigClientService.getAllEnvServerlist();
    }

    @Service
    public String logPath() {
        return LoggerHelper.getLogpath();
    }

    @Service
    public String clientCachePath() {
        return LocalConfigInfo.SNAPSHOT_ROOT;
    }

    @Service
    public boolean setNoCachePersist(@Parameter(name="isNoCache") boolean isNoCache) {
        return ConfigClientService.setNoCachePersist(isNoCache);
    }

    @Service
    public boolean setNotRollSnapshot(@Parameter(name="isNotRoll") boolean isNotRoll) {
        return ConfigClientService.setNotRollSnapshot(isNotRoll);
    }
}

