/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client.processor;

import com.taobao.config.client.DefaultSubscriber;
import com.taobao.config.client.SubscriberRegistrar;
import com.taobao.config.client.processor.ProtocolElementProcessor;
import com.taobao.config.common.protocol.ProtocolElement;
import com.taobao.config.common.protocol.ProtocolPackage;
import com.taobao.config.common.protocol.UserDataElement;
import com.taobao.config.common.protocol.weight.RulesElement;
import com.taobao.config.common.utils.StringUtils;
import java.util.List;

public class RulesElementProcessor
extends ProtocolElementProcessor {
    @Override
    public void process(ProtocolElement input, ProtocolPackage pp) {
        String[] clientIds;
        RulesElement element = (RulesElement)input;
        String dataId = element.getDataId();
        String clientId = element.getClientId();
        log.info("########## [weightRule-received :] (DataID: " + dataId + " clientId:" + clientId + " weightValueSize:" + element.getValues().size());
        if (StringUtils.isBlank(clientId)) {
            log.error("%s", "[Protocol] Empty client ID list in RulesElement, try searching clients locally.");
            clientIds = null;
        } else {
            clientIds = new String[]{clientId};
        }
        if (dataId == null) {
            String userDataElementDataId;
            UserDataElement userDataElement = this.getUserDataElement(pp);
            if (userDataElement == null) {
                log.error("%s", "[Protocol] Protocol error in dataId null and NO userDataElement in ProtocolPackage");
                return;
            }
            dataId = userDataElementDataId = userDataElement.dataId;
        }
        if (dataId == null) {
            log.error("%s", "[Protocol] Protocol error in parsing UserDataElement and RulesElement!");
            return;
        }
        if (clientIds == null) {
            List<String> clientIdList = SubscriberRegistrar.findClientIdsByDataId(dataId);
            clientIds = clientIdList.toArray(new String[clientIdList.size()]);
        }
        for (String clientIdValue : clientIds) {
            if (clientIdValue == null || clientIdValue.length() <= 0) {
                log.error("%s", "[Protocol] Null or empty client ID in RulesElement.");
                continue;
            }
            DefaultSubscriber subscriber = null;
            for (int failCount = 0; null == subscriber && failCount < 3; ++failCount) {
                subscriber = SubscriberRegistrar.find(clientIdValue);
                if (subscriber != null) continue;
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (Exception e) {
                    log.error("%s", e.toString(), e);
                }
            }
            if (null != subscriber) {
                if (null == element || !subscriber.setWeightValue(element.getValues())) continue;
                subscriber.notifyObServer();
                continue;
            }
            log.warn("########## [subscriber-not-found] (DataID: " + dataId + ", ClientID:" + clientIdValue + ")");
        }
    }

    private UserDataElement getUserDataElement(ProtocolPackage pp) {
        for (ProtocolElement item : pp) {
            if (!(item instanceof UserDataElement)) continue;
            return (UserDataElement)item;
        }
        return null;
    }
}

