/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client.remoting;

import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.ConfigClientWorker;
import com.taobao.config.client.DefaultDataClient;
import com.taobao.config.client.DefaultPublisher;
import com.taobao.config.client.DefaultSubscriber;
import com.taobao.config.client.PublisherRegistrar;
import com.taobao.config.client.SubscriberRegistrar;
import com.taobao.middleware.logger.Logger;
import com.taobao.remoting.Connection;
import com.taobao.remoting.IOEventListener;
import java.util.Iterator;

public class ConnectionListener
implements IOEventListener.ConnectionLifecycleListener {
    private static final Logger logger = ConfigClientLogger.getLogger(ConnectionListener.class);
    private ConfigClientWorker configClientWorker;

    public ConnectionListener(ConfigClientWorker configClientWorker) {
        this.configClientWorker = configClientWorker;
    }

    @Override
    public void connectionClosed(Connection conn) {
        logger.warn("[Global] Server connection is closed just recently [" + conn + "] , Will try reconnecting soon or it has been reconnected");
        Iterator<DefaultDataClient> iter = PublisherRegistrar.publisherIterator();
        while (iter.hasNext()) {
            DefaultPublisher<?> pub = iter.next();
            if (pub.getServerListManager() != this.configClientWorker.getServerListManager()) continue;
            logger.info("[Re-Registering] Publisher dataId=" + pub.getDataId() + ", clientId=" + pub.getClientId());
            pub.onServerDisconnected();
        }
        iter = SubscriberRegistrar.subscriberIterator();
        while (iter.hasNext()) {
            DefaultSubscriber sub = (DefaultSubscriber)iter.next();
            if (sub.getServerListManager() != this.configClientWorker.getServerListManager()) continue;
            logger.info("[Re-Registering] Subcriber dataId=" + sub.getDataId() + ", clientId=" + sub.getClientId());
            sub.onServerDisconnected();
        }
        logger.info("[Global] Removing Server connection [" + conn + "]");
    }

    @Override
    public void connectionOpened(Connection conn) {
    }
}

