/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client.remoting;

import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.ConfigClientWorker;
import com.taobao.config.common.protocol.ProtocolPackage;
import com.taobao.middleware.logger.Logger;
import com.taobao.remoting.RequestProcessor;
import com.taobao.remoting.util.DIYExecutor;
import java.util.concurrent.Executor;

public class ConnectionRequestProcessor
implements RequestProcessor<ProtocolPackage> {
    private static final Logger logger = ConfigClientLogger.getLogger(ConnectionRequestProcessor.class);
    private ConfigClientWorker configClientWorker;

    public ConnectionRequestProcessor(ConfigClientWorker configClientWorker) {
        this.configClientWorker = configClientWorker;
    }

    @Override
    public void handleRequest(ProtocolPackage appRequest, RequestProcessor.AppResponseOutput connResp) {
        if (this.configClientWorker.getMailbox().offer(appRequest)) {
            this.configClientWorker.signal();
            connResp.write(new ProtocolPackage());
        } else {
            logger.error("%s", "[Global] Push message discarded 'cause mailbox overflow.");
        }
    }

    @Override
    public Executor getExecutor() {
        return DIYExecutor.getInstance();
    }

    @Override
    public Class<ProtocolPackage> interest() {
        return ProtocolPackage.class;
    }

    @Override
    public void onRejectedExecutionException(ProtocolPackage packagee, RequestProcessor.AppResponseOutput out) {
    }
}

