/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client.utils;

import com.taobao.config.client.http.HttpResult;
import com.taobao.config.client.utils.IOUtils;
import java.io.IOException;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class HttpUtils {
    static final int TIMEOUT = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult invokeURL(String url) throws IOException {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            conn.setRequestMethod("GET");
            conn.setInstanceFollowRedirects(false);
            conn.connect();
            int respCode = conn.getResponseCode();
            String resp = null;
            if (200 == respCode) {
                resp = IOUtils.toString(conn.getInputStream(), null);
            } else if (conn.getErrorStream() != null) {
                resp = IOUtils.toString(conn.getErrorStream(), null);
            }
            HttpResult httpResult = new HttpResult(respCode, resp);
            return httpResult;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static List<String> httpResultLines(HttpResult httpResult) throws IOException {
        List<String> lines = IOUtils.readLines(new StringReader(httpResult.content));
        ArrayList<String> result = new ArrayList<String>(lines.size());
        for (String line : lines) {
            if (null == line || line.trim().isEmpty()) continue;
            result.add(line.trim());
        }
        return result;
    }
}

