/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client.utils;

import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.bean.ObserverData;
import com.taobao.middleware.logger.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObserverDataUtils {
    private static final Logger log = ConfigClientLogger.getLogger(ObserverDataUtils.class);

    public static List<ObserverData> getObserverData(List<Object> datas, List<Map<String, String>> baseDatas) {
        if (datas.size() != baseDatas.size()) {
            log.info("ObserverDataUtils.getObserverData datas.size(" + datas.size() + ") != baseDatas.size(" + baseDatas.size() + "),return ObserverData without metaData");
            return ObserverDataUtils.getObserverData(datas);
        }
        ArrayList<ObserverData> observerDatas = new ArrayList<ObserverData>();
        for (int i = 0; i < datas.size(); ++i) {
            ObserverData observerData = new ObserverData(datas.get(i));
            observerData.setBaseData(baseDatas.get(i));
            observerDatas.add(observerData);
        }
        return observerDatas;
    }

    public static List<Object> getDataFromObserverDataMap(Map<String, List<ObserverData>> baseDataMap) {
        if (baseDataMap == null) {
            log.info("ObserverDataUtils.getDataFromObserverDataMap baseDataMap is null");
        }
        ArrayList<Object> resultDatas = new ArrayList<Object>();
        for (Map.Entry<String, List<ObserverData>> entry : baseDataMap.entrySet()) {
            List<ObserverData> observerDatas = entry.getValue();
            if (observerDatas == null) continue;
            List<Object> datas = ObserverDataUtils.getDataFromObserverData(observerDatas);
            resultDatas.addAll(datas);
        }
        return resultDatas;
    }

    public static List<Object> getDataFromObserverData(List<ObserverData> baseDatas) {
        if (baseDatas == null) {
            log.info("ObserverDataUtils.getDataFromObserverData baseDatas is null");
        }
        ArrayList<Object> datas = new ArrayList<Object>();
        for (int i = 0; i < baseDatas.size(); ++i) {
            ObserverData observerData = baseDatas.get(i);
            datas.add(observerData.getData());
        }
        return datas;
    }

    public static Map<String, List<ObserverData>> getObserverDataMapFromData(List<Object> datas) {
        if (datas == null) {
            log.info("ObserverDataUtils.getObserverDataMapFromData datas is null");
        }
        HashMap<String, List<ObserverData>> resultMap = new HashMap<String, List<ObserverData>>();
        List<ObserverData> observerDatas = ObserverDataUtils.getObserverData(datas);
        resultMap.put("default", observerDatas);
        return resultMap;
    }

    private static List<ObserverData> getObserverData(List<Object> datas) {
        ArrayList<ObserverData> observerDatas = new ArrayList<ObserverData>();
        for (Object data : datas) {
            observerDatas.add(new ObserverData(data));
        }
        return observerDatas;
    }
}

