/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.common.protocol;

import com.taobao.config.common.protocol.ProtocolElement;
import com.taobao.config.common.protocol.ProtocolElementUid;
import com.taobao.config.common.protocol.SinceVersion;

public final class VersionElement
implements ProtocolElement,
Comparable<VersionElement> {
    public short major;
    public short minor;
    public int build;
    public static final VersionElement CURRENT = new VersionElement(1, 2, 0);
    private static final long serialVersionUID = 1L;

    public VersionElement(int major, int minor, int build) {
        this.set(major, minor, build);
    }

    public void set(int major, int minor, int build) {
        this.major = (short)major;
        this.minor = (short)minor;
        this.build = build;
    }

    public void set(VersionElement element) {
        this.set(element.major, element.minor, element.build);
    }

    public boolean isSupported() {
        return CURRENT.equals(this);
    }

    public boolean isSupported(VersionElement minVersion, VersionElement maxVersion) {
        long version = this.toLong();
        return version >= minVersion.toLong() && version <= minVersion.toLong();
    }

    public boolean isSupported(SinceVersion since) {
        return this.major >= since.major() && this.minor >= since.minor() && this.build >= since.build();
    }

    @Override
    public int compareTo(VersionElement that) {
        if (this.major > that.major) {
            return 1;
        }
        if (this.major < that.major) {
            return -1;
        }
        if (this.minor > that.minor) {
            return 1;
        }
        if (this.minor < that.minor) {
            return -1;
        }
        if (this.build > that.build) {
            return 1;
        }
        if (this.build < that.build) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.build;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionElement other = (VersionElement)obj;
        if (this.build != other.build) {
            return false;
        }
        if (this.major != other.major) {
            return false;
        }
        return this.minor == other.minor;
    }

    private long toLong() {
        return this.major << 48 + this.minor << 32 + this.build;
    }

    @Override
    public ProtocolElementUid uid() {
        return ProtocolElementUid.ELEMENT_VERSION;
    }
}

