/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.common.task;

import com.taobao.config.common.task.Arrow;
import com.taobao.config.common.task.Prioritized;
import com.taobao.config.common.task.Priority;
import com.taobao.config.common.task.Quiver;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class AncientSinewWrappedLamina
implements Quiver {
    private static final int NUM_POLL_SPINS = 256;
    private static final long TASK_PATROL_INTERVAL = 5000L;
    private static final Arrow dummyArrow = new DummyArrow();
    private final AtomicInteger count = new AtomicInteger(0);
    private final BlockingQueue<Arrow> q0 = new PriorityBlockingQueue<Arrow>();
    private final BlockingQueue<Arrow> q1 = new LinkedBlockingQueue<Arrow>();
    private final BlockingQueue<Arrow> q2 = new PriorityBlockingQueue<Arrow>();
    private volatile boolean q0NotEmpty = false;

    AncientSinewWrappedLamina() {
    }

    @Override
    public boolean load(Arrow arrow) {
        boolean result;
        if (!arrow.nock()) {
            return false;
        }
        if (arrow instanceof Prioritized) {
            Priority priority = ((Prioritized)((Object)arrow)).priority();
            try {
                int comparison = priority.compareTo(Priority.NORMAL);
                if (comparison == 0) {
                    result = this.q1.offer(arrow);
                }
                if (comparison < 0) {
                    result = this.q2.offer(arrow);
                    this.signalNotEmpty();
                }
                result = this.q0.offer(arrow);
                this.q0NotEmpty = true;
                this.signalNotEmpty();
            }
            catch (RuntimeException e) {
                assert (arrow.trash());
                throw e;
            }
        } else {
            result = this.q1.offer(arrow);
        }
        if (result) {
            this.count.incrementAndGet();
        }
        return result;
    }

    private void signalNotEmpty() {
        if (this.q1.size() == 0) assert (this.q1.offer(dummyArrow));
    }

    @Override
    public Arrow pick() throws InterruptedException {
        Arrow t1;
        while (true) {
            if (this.count.get() > 0) {
                block6: {
                    if (this.q0NotEmpty) {
                        this.q0NotEmpty = false;
                        Arrow t0 = (Arrow)this.q0.poll();
                        if (t0 != null) {
                            this.count.decrementAndGet();
                            return t0;
                        }
                    }
                    do {
                        for (int spin = 256; (t1 = (Arrow)this.q1.poll()) == null && spin > 0; --spin) {
                        }
                        if (t1 == null) break block6;
                    } while (t1 == dummyArrow);
                    this.count.decrementAndGet();
                    return t1;
                }
                Arrow t2 = (Arrow)this.q2.poll();
                if (t2 == null) continue;
                this.count.decrementAndGet();
                return t2;
            }
            t1 = this.q1.poll(5000L, TimeUnit.MILLISECONDS);
            if (t1 != null && t1 != dummyArrow) break;
        }
        this.count.decrementAndGet();
        return t1;
    }

    private static class DummyArrow
    implements Arrow {
        private DummyArrow() {
        }

        @Override
        public boolean nock() {
            return false;
        }

        @Override
        public boolean renock() {
            return false;
        }

        @Override
        public boolean trash() {
            return false;
        }

        @Override
        public void run() {
            throw new Error("DummyArrow should never run");
        }
    }
}

