/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.middleware.logger.option;

import com.alibaba.cs.shaded.ch.qos.logback.classic.AsyncAppender;
import com.alibaba.cs.shaded.ch.qos.logback.classic.PatternLayout;
import com.alibaba.cs.shaded.ch.qos.logback.classic.spi.ILoggingEvent;
import com.alibaba.cs.shaded.ch.qos.logback.core.Appender;
import com.alibaba.cs.shaded.ch.qos.logback.core.ConsoleAppender;
import com.alibaba.cs.shaded.ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import com.alibaba.cs.shaded.ch.qos.logback.core.rolling.RollingFileAppender;
import com.alibaba.cs.shaded.ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import com.alibaba.cs.shaded.ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import com.alibaba.cs.shaded.ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import com.alibaba.cs.shaded.ch.qos.logback.core.util.FileSize;
import com.taobao.middleware.logger.Level;
import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.option.AbstractActiveOption;
import com.taobao.middleware.logger.option.LogbackLoggerContextUtil;
import com.taobao.middleware.logger.support.LoggerHelper;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Iterator;

public class Logback918ActivateOption
extends AbstractActiveOption {
    private com.alibaba.cs.shaded.ch.qos.logback.classic.Logger logger;

    public Logback918ActivateOption(Object logger) {
        if (!(logger instanceof com.alibaba.cs.shaded.ch.qos.logback.classic.Logger)) {
            throw new IllegalArgumentException("logger must be instanceof ch.qos.logback.classic.Logger");
        }
        this.logger = (com.alibaba.cs.shaded.ch.qos.logback.classic.Logger)logger;
    }

    @Override
    public void activateConsoleAppender(String target, String encoding) {
        ConsoleAppender<ILoggingEvent> appender = new ConsoleAppender<ILoggingEvent>();
        appender.setContext(LogbackLoggerContextUtil.getLoggerContext());
        appender.setTarget(target);
        PatternLayout layout = new PatternLayout();
        layout.setPattern(LoggerHelper.getPattern());
        layout.setContext(LogbackLoggerContextUtil.getLoggerContext());
        layout.start();
        appender.setLayout(layout);
        appender.start();
        this.logger.detachAndStopAllAppenders();
        this.logger.addAppender((Appender<ILoggingEvent>)appender);
    }

    @Override
    public void activateAppender(String productName, String file, String encoding) {
        Appender appender = this.getLogbackDailyRollingFileAppender(productName, file, encoding);
        this.logger.detachAndStopAllAppenders();
        this.logger.addAppender(appender);
        this.setProductName(productName);
    }

    @Override
    public void activateAsyncAppender(String productName, String file, String encoding) {
        this.activateAsyncAppender(productName, file, encoding, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    @Override
    public void activateAsyncAppender(String productName, String file, String encoding, int queueSize, int discardingThreshold) {
        AsyncAppender asynAppender = new AsyncAppender();
        if (queueSize != Integer.MIN_VALUE) {
            asynAppender.setQueueSize(queueSize);
        }
        if (discardingThreshold != Integer.MIN_VALUE) {
            asynAppender.setDiscardingThreshold(discardingThreshold);
        }
        asynAppender.setName(productName + "." + file.replace(File.separatorChar, '.') + ".AsyncAppender");
        asynAppender.setContext(LogbackLoggerContextUtil.getLoggerContext());
        Appender appender = this.getLogbackDailyRollingFileAppender(productName, file, encoding);
        asynAppender.addAppender(appender);
        asynAppender.start();
        this.logger.detachAndStopAllAppenders();
        this.logger.addAppender(asynAppender);
        this.setProductName(productName);
    }

    @Override
    public void setLevel(Level level) {
        this.level = level;
        this.logger.setLevel(com.alibaba.cs.shaded.ch.qos.logback.classic.Level.valueOf(level.getName()));
    }

    @Override
    public void setAdditivity(boolean additivity) {
        this.logger.setAdditive(additivity);
    }

    @Override
    public void activateAppenderWithTimeAndSizeRolling(String productName, String file, String encoding, String size) {
        Appender appender = this.getLogbackDailyAndSizeRollingFileAppender(productName, file, encoding, size);
        this.logger.detachAndStopAllAppenders();
        this.logger.addAppender(appender);
        this.setProductName(productName);
    }

    protected Appender getLogbackDailyRollingFileAppender(String productName, String file, String encoding) {
        RollingFileAppender<ILoggingEvent> appender = new RollingFileAppender<ILoggingEvent>();
        appender.setContext(LogbackLoggerContextUtil.getLoggerContext());
        appender.setName(productName + "." + file.replace(File.separatorChar, '.') + ".Appender");
        appender.setAppend(true);
        appender.setFile(LoggerHelper.getLogFile(productName, file));
        TimeBasedRollingPolicy rolling = new TimeBasedRollingPolicy();
        rolling.setParent(appender);
        rolling.setFileNamePattern(LoggerHelper.getLogFile(productName, file) + ".%d{yyyy-MM-dd}");
        rolling.setContext(LogbackLoggerContextUtil.getLoggerContext());
        rolling.start();
        appender.setRollingPolicy(rolling);
        PatternLayout layout = new PatternLayout();
        layout.setPattern(LoggerHelper.getPattern(productName));
        layout.setContext(LogbackLoggerContextUtil.getLoggerContext());
        layout.start();
        appender.setLayout(layout);
        appender.start();
        return appender;
    }

    protected Appender getLogbackDailyAndSizeRollingFileAppender(String productName, String file, String encoding, String size) {
        return this.getLogbackDailyAndSizeRollingFileAppender(productName, file, encoding, size, "yyyy-MM-dd", -1);
    }

    @Override
    public void activateAppender(Logger logger) {
        if (!(logger.getDelegate() instanceof com.alibaba.cs.shaded.ch.qos.logback.classic.Logger)) {
            throw new IllegalArgumentException("logger must be ch.qos.logback.classic.Logger, but it's " + logger.getDelegate().getClass());
        }
        this.logger.detachAndStopAllAppenders();
        Iterator<Appender<ILoggingEvent>> iter = ((com.alibaba.cs.shaded.ch.qos.logback.classic.Logger)logger.getDelegate()).iteratorForAppenders();
        while (iter.hasNext()) {
            Appender<ILoggingEvent> appender = iter.next();
            this.logger.addAppender(appender);
        }
    }

    @Override
    public void activateAppenderWithTimeAndSizeRolling(String productName, String file, String encoding, String size, String datePattern) {
        Appender appender = this.getLogbackDailyAndSizeRollingFileAppender(productName, file, encoding, size, datePattern, -1);
        this.logger.detachAndStopAllAppenders();
        this.logger.addAppender(appender);
        this.setProductName(productName);
    }

    protected Appender getLogbackDailyAndSizeRollingFileAppender(String productName, String file, String encoding, String size, String datePattern, int maxBackupIndex) {
        RollingFileAppender<ILoggingEvent> appender = new RollingFileAppender<ILoggingEvent>();
        appender.setContext(LogbackLoggerContextUtil.getLoggerContext());
        appender.setName(productName + "." + file.replace(File.separatorChar, '.') + ".Appender");
        appender.setAppend(true);
        appender.setFile(LoggerHelper.getLogFile(productName, file));
        TimeBasedRollingPolicy rolling = new TimeBasedRollingPolicy();
        rolling.setParent(appender);
        if (maxBackupIndex >= 0) {
            rolling.setMaxHistory(maxBackupIndex);
        }
        rolling.setFileNamePattern(LoggerHelper.getLogFile(productName, file) + ".%d{" + datePattern + "}.%i");
        rolling.setContext(LogbackLoggerContextUtil.getLoggerContext());
        SizeAndTimeBasedFNATP fnatp = new SizeAndTimeBasedFNATP();
        this.setMaxFileSize(fnatp, size);
        fnatp.setTimeBasedRollingPolicy(rolling);
        rolling.setTimeBasedFileNamingAndTriggeringPolicy(fnatp);
        rolling.start();
        appender.setRollingPolicy(rolling);
        PatternLayout layout = new PatternLayout();
        layout.setPattern(LoggerHelper.getPattern(productName));
        layout.setContext(LogbackLoggerContextUtil.getLoggerContext());
        layout.start();
        appender.setLayout(layout);
        appender.start();
        return appender;
    }

    @Override
    public void activateAppenderWithTimeAndSizeRolling(String productName, String file, String encoding, String size, String datePattern, int maxBackupIndex) {
        Appender appender = this.getLogbackDailyAndSizeRollingFileAppender(productName, file, encoding, size, datePattern, maxBackupIndex);
        this.logger.detachAndStopAllAppenders();
        this.logger.addAppender(appender);
        this.setProductName(productName);
    }

    @Override
    public void activateAppenderWithSizeRolling(String productName, String file, String encoding, String size, int maxBackupIndex) {
        Appender appender = this.getSizeRollingAppender(productName, file, encoding, size, maxBackupIndex);
        this.logger.detachAndStopAllAppenders();
        this.logger.addAppender(appender);
        this.setProductName(productName);
    }

    protected Appender getSizeRollingAppender(String productName, String file, String encoding, String size, int maxBackupIndex) {
        RollingFileAppender appender = new RollingFileAppender();
        appender.setContext(LogbackLoggerContextUtil.getLoggerContext());
        appender.setName(productName + "." + file.replace(File.separatorChar, '.') + ".Appender");
        appender.setAppend(true);
        appender.setFile(LoggerHelper.getLogFile(productName, file));
        SizeBasedTriggeringPolicy triggerPolicy = new SizeBasedTriggeringPolicy();
        this.setMaxFileSize(triggerPolicy, size);
        triggerPolicy.setContext(LogbackLoggerContextUtil.getLoggerContext());
        triggerPolicy.start();
        FixedWindowRollingPolicy rolling = new FixedWindowRollingPolicy();
        rolling.setContext(LogbackLoggerContextUtil.getLoggerContext());
        rolling.setParent(appender);
        rolling.setFileNamePattern(LoggerHelper.getLogFile(productName, file) + ".%i");
        rolling.setParent(appender);
        if (maxBackupIndex >= 0) {
            rolling.setMaxIndex(maxBackupIndex);
        }
        rolling.start();
        appender.setRollingPolicy(rolling);
        appender.setTriggeringPolicy(triggerPolicy);
        PatternLayout layout = new PatternLayout();
        layout.setPattern(LoggerHelper.getPattern(productName));
        layout.setContext(LogbackLoggerContextUtil.getLoggerContext());
        layout.start();
        appender.setLayout(layout);
        appender.start();
        return appender;
    }

    protected void setMaxFileSize(Object policy, String size) {
        try {
            try {
                Method setMaxFileSizeMethod = policy.getClass().getDeclaredMethod("setMaxFileSize", String.class);
                setMaxFileSizeMethod.invoke(policy, size);
            }
            catch (NoSuchMethodException e) {
                Method setMaxFileSizeMethod = policy.getClass().getDeclaredMethod("setMaxFileSize", FileSize.class);
                setMaxFileSizeMethod.invoke(policy, FileSize.valueOf(size));
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to setMaxFileSize", t);
        }
    }
}

