/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.impl;

import com.taobao.remoting.Client;
import com.taobao.remoting.Connection;
import com.taobao.remoting.IOEventListener;
import com.taobao.remoting.Remoting;
import com.taobao.remoting.impl.ConnectionHeartBeat;
import com.taobao.remoting.impl.DefaultConnection;
import com.taobao.remoting.impl.HeartBeatProcessor;
import com.taobao.remoting.locale.LogResources;
import com.taobao.remoting.util.ConnectionUrl;
import com.taobao.remoting.util.LoggerInit;

class CL_IdleListener
implements IOEventListener.ConnectionIdleListener {
    CL_IdleListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionIdle(Connection conn) {
        boolean isIdleTimeout;
        String url;
        long current = System.currentTimeMillis();
        long lastRead = ((DefaultConnection)conn).getIoSession().getLastReadTime();
        long idleTime = 0L;
        long maxReadIdle = 30000L;
        String string = url = conn.isClientSide() ? conn.getClient().getConnectionUrl() : HeartBeatProcessor.clientTargetUrl(conn);
        if (null != url) {
            idleTime = (long)ConnectionUrl.getIdleTimeout(url) * 1000L;
            maxReadIdle = (long)ConnectionUrl.getMaxReadIdle(url) * 1000L;
        }
        boolean bl = isIdleTimeout = current - lastRead >= idleTime + maxReadIdle;
        if (isIdleTimeout && Remoting.isCloseWhenIdleTimeout()) {
            String msg = null;
            try {
                String label = conn.isClientSide() ? "clientExceedsMaxReadIdle" : "serverExceedsMaxReadIdle";
                msg = LogResources.getLog(label, (current - lastRead) / 1000L);
                conn.close(msg);
            }
            catch (Throwable throwable) {
                conn.close(msg);
                throw throwable;
            }
        } else if (conn.isClientSide()) {
            Client client = conn.getClient();
            ConnectionHeartBeat hb = new ConnectionHeartBeat(client.getConnectionUrl());
            client.invokeWithFuture(hb, null);
            LoggerInit.LOGGER.debug("[heart-beat] To " + conn.getRemoteSocket());
        }
    }
}

