/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.impl;

import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.ConnectFuture;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.ThreadModel;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.transport.socket.nio.SocketConnector;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.transport.socket.nio.SocketConnectorConfig;
import com.taobao.remoting.Client;
import com.taobao.remoting.ClientManager;
import com.taobao.remoting.Connection;
import com.taobao.remoting.IOEventListener;
import com.taobao.remoting.RemotingException;
import com.taobao.remoting.impl.ClientFutureImpl;
import com.taobao.remoting.impl.ClientKeyUtil;
import com.taobao.remoting.impl.DefaultConnectionFactory;
import com.taobao.remoting.impl.DefaultIoHandler;
import com.taobao.remoting.impl.LCL_negotiateIdleTimeout;
import com.taobao.remoting.impl.LCL_onClose4Reconnect;
import com.taobao.remoting.impl.socks.Socks5IoHandler;
import com.taobao.remoting.util.ConnectionUrl;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

class ClientConnectionFactory
extends DefaultConnectionFactory {
    private static final long serialVersionUID = 1L;
    private final String appName;
    private final SocketConnector connector;

    ClientConnectionFactory(String _appName) {
        this.appName = _appName;
        this.addListener(new LCL_negotiateIdleTimeout());
        this.addListener(new LCL_onClose4Reconnect());
        this.connector = new SocketConnector(processorCount, IO_THREAD_POOL);
    }

    Client createClient(String targetUrl, InetSocketAddress localAddress, List<IOEventListener> ioListeners) throws RemotingException, InterruptedException {
        return this.createClientAsync(targetUrl, localAddress, ioListeners).get(-1L);
    }

    ClientManager.ClientFuture createClientAsync(String url, List<IOEventListener> ioListeners) {
        return this.createClientAsync(url, null, ioListeners);
    }

    ClientManager.ClientFuture createClientAsync(String targetUrl, InetSocketAddress localAddress, List<IOEventListener> ioListeners) {
        String clientKey = ClientKeyUtil.singleClientKey(this.appName, targetUrl, localAddress);
        ArrayList<IOEventListener> copyListeners = new ArrayList<IOEventListener>();
        if (null != ioListeners) {
            copyListeners.addAll(ioListeners);
        }
        String socksProxyHost = System.getProperty("socksProxyHost");
        SocketConnectorConfig cfg = new SocketConnectorConfig();
        cfg.setThreadModel(ThreadModel.MANUAL);
        long timeoutMs = Math.max(ConnectionUrl.getConnectTimeout(targetUrl), 1000L);
        long timeoutSeconds = timeoutMs / 1000L;
        cfg.setConnectTimeout(timeoutSeconds > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)timeoutSeconds);
        cfg.getSessionConfig().setTcpNoDelay(true);
        InetSocketAddress socketAddr = ConnectionUrl.socketAddr(targetUrl);
        if (socksProxyHost != null) {
            String portStr = System.getProperty("socksProxyPort");
            InetSocketAddress targetAddr = socketAddr;
            socketAddr = new InetSocketAddress(socksProxyHost, portStr != null ? Integer.valueOf(portStr) : 1080);
            Socks5IoHandler.StateHodler stateHodler = new Socks5IoHandler.StateHodler();
            Socks5IoHandler socks5ProtocolCodec = new Socks5IoHandler(stateHodler, targetAddr, cfg);
            cfg.getFilterChain().addLast(Socks5IoHandler.class.getSimpleName(), socks5ProtocolCodec);
        }
        cfg.getFilterChain().addLast("objectserialize", CODEC_FILTER);
        ConnectFuture minaConnectFuture = this.connector.connect(socketAddr, localAddress, new DefaultIoHandler.ClientIoHandler(this, clientKey, copyListeners), cfg);
        ClientFutureImpl cf = new ClientFutureImpl(targetUrl, minaConnectFuture);
        return cf;
    }

    void closeAllClients() {
        for (Connection conn : this.allConnectionSnapshot()) {
            conn.close("\u6d4b\u8bd5\u4e13\u7528\u3002\u5173\u95ed\u8be5\u8fde\u63a5\u5de5\u5382\u5185\u7684\u6240\u6709\u8fde\u63a5");
        }
    }
}

