/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.impl;

import com.taobao.remoting.TRConstants;
import com.taobao.remoting.impl.ConnectionRequest;
import com.taobao.remoting.impl.RemotingMessage;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;

public class ConnectionResponse
implements RemotingMessage {
    private static final long serialVersionUID = 1L;
    private ResponseContext ctx = new ResponseContext();
    private String host;
    private int result = 0;
    private String errorMsg;
    private String errorStack;
    private transient Object errorCause;
    private transient Object appResponse;

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public long getRequestId() {
        return this.ctx.id;
    }

    public void setRequestId(long requestId) {
        this.ctx.id = requestId;
    }

    @Override
    public long getMessageId() {
        return this.ctx.id;
    }

    @Override
    public byte getSerializeProtocol() {
        return this.ctx.serializeProtocol;
    }

    public void setSerializeProtocol(byte serializeType) {
        this.ctx.serializeProtocol = serializeType;
    }

    public Object getAppResponse() {
        return this.appResponse;
    }

    public void setAppResponse(Object response) {
        this.appResponse = response;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String error) {
        this.errorMsg = error;
    }

    public Object getErrorCause() {
        return this.errorCause;
    }

    public void setErrorCause(Object cause) {
        this.errorCause = cause;
    }

    public String getErrorStack() {
        return this.errorStack;
    }

    public void setErrorStack(String _errorStack) {
        this.result = 1;
        this.errorStack = "[Server Error Stack]: " + _errorStack;
    }

    public void setThrowable(Throwable t) {
        this.setErrorMsg(t.toString());
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        writer.flush();
        this.setErrorStack(stringWriter.toString());
        writer.close();
    }

    public byte getDirection() {
        return this.ctx.direction;
    }

    public void setDirection(byte direction) {
        this.ctx.direction = direction;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectionResponse[");
        sb.append("requestId=").append(this.ctx.id);
        sb.append(", result=").append(TRConstants.getResultCodeMsg(this.result));
        sb.append(", errorMsg=").append(this.errorMsg);
        sb.append(", appResponse=").append(this.appResponse);
        sb.append("]");
        return sb.toString();
    }

    public static ConnectionResponse getResponse(ConnectionRequest request) {
        ConnectionResponse resp = new ConnectionResponse();
        resp.setRequestId(request.getId());
        resp.setDirection(request.getDirection());
        resp.setSerializeProtocol(request.getSerializeProtocol());
        return resp;
    }

    private class ResponseContext
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private long id;
        private transient byte serializeProtocol;
        private transient byte direction = (byte)2;

        private ResponseContext() {
        }
    }
}

