/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.impl;

import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoConnector;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoFutureListener;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoSession;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.WriteFuture;
import com.taobao.remoting.Client;
import com.taobao.remoting.Connection;
import com.taobao.remoting.ConnectionFactory;
import com.taobao.remoting.IOEventListener;
import com.taobao.remoting.OverFlowWriteFuture;
import com.taobao.remoting.impl.ConnectionRequest;
import com.taobao.remoting.impl.DefaultClient;
import com.taobao.remoting.impl.DefaultMsgListener;
import com.taobao.remoting.impl.LCL_AliveSessionsListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class DefaultConnection
implements Connection {
    private static final String SESSION_CONN = "session2connection";
    private final IoSession session;
    private final ConnectionFactory factory;
    private final boolean isClientSide;
    private byte lastRequestProtocol = (byte)-1;
    private final CopyOnWriteArrayList<IOEventListener> ioListeners = new CopyOnWriteArrayList();
    private final IOEventListener.ConnectionMsgReceivedListener msgListener;

    public DefaultConnection(IoSession _session, ConnectionFactory _factory) {
        if (null == _session) {
            throw new IllegalArgumentException("session is null");
        }
        this.session = _session;
        this.factory = _factory;
        this.session.setAttribute(SESSION_CONN, this);
        this.session.setWriteTimeout(10);
        this.isClientSide = this.session.getService() instanceof IoConnector;
        this.msgListener = new DefaultMsgListener();
        this.addConnectionEvtListener(this.msgListener);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.session.setAttribute(SESSION_CONN, this);
    }

    public static final DefaultConnection findBySession(IoSession session) {
        return (DefaultConnection)session.getAttribute(SESSION_CONN);
    }

    @Override
    @Deprecated
    public void close() {
        if (this.session.isConnected()) {
            this.session.close();
        }
    }

    @Override
    public void close(String cause) {
        if (this.session.isConnected()) {
            this.session.close(cause);
        }
    }

    @Override
    public boolean isConnected() {
        return this.session != null && !this.session.isClosing();
    }

    @Override
    public int getRemotePort() {
        return ((InetSocketAddress)this.session.getRemoteAddress()).getPort();
    }

    @Override
    public String getRemoteAddress() {
        InetSocketAddress remoteSocket = (InetSocketAddress)this.session.getRemoteAddress();
        return remoteSocket.getAddress().getHostAddress();
    }

    @Override
    public String getRemoteSocket() {
        return this.getRemoteAddress() + ":" + this.getRemotePort();
    }

    @Override
    public int getLocalPort() {
        return ((InetSocketAddress)this.session.getLocalAddress()).getPort();
    }

    @Override
    public String getLocalAddress() {
        InetSocketAddress localSocket = (InetSocketAddress)this.session.getLocalAddress();
        return localSocket.getAddress().getHostAddress();
    }

    @Override
    public String getLocalSocket() {
        return this.getLocalAddress() + ":" + this.getLocalPort();
    }

    @Override
    public boolean isClientSide() {
        return this.isClientSide;
    }

    @Override
    public Client getClient() {
        return DefaultClient.findBySession(this.session);
    }

    @Override
    public ConnectionFactory getConnectionFactory() {
        return this.factory;
    }

    @Override
    public <T> T setAttribute(String key, T value) {
        return (T)this.session.setAttribute(key, value);
    }

    @Override
    public <T> T removeAttribute(String key) {
        return (T)this.session.removeAttribute(key);
    }

    @Override
    public <T> T getAttribute(String key) {
        return (T)this.session.getAttribute(key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("L=" + this.getLocalAddress() + ":" + this.getLocalPort());
        sb.append(", R=" + this.getRemoteAddress() + ":" + this.getRemotePort());
        sb.append(", S=" + (this.isConnected() ? "Connected" : "DisConnected"));
        return sb.toString();
    }

    IoSession getSession() {
        return this.session;
    }

    @Override
    public WriteFuture write(Object connectionMsg, IoFutureListener wfl) {
        if (connectionMsg instanceof ConnectionRequest) {
            ((ConnectionRequest)connectionMsg).setClient(this.getClient());
        }
        if (OverFlowWriteFuture.getThreshold() > 0L) {
            long notFlushed = 0L;
            for (DefaultConnection conn : LCL_AliveSessionsListener.aliveSessions()) {
                notFlushed += (long)conn.session.getScheduledWriteBytes();
            }
            if (notFlushed >= OverFlowWriteFuture.getThreshold()) {
                return new OverFlowWriteFuture(this.session, wfl, notFlushed);
            }
        }
        return this.session.write(connectionMsg, wfl);
    }

    @Override
    public void write(Object connectionMsg) {
        this.write(connectionMsg, null);
    }

    @Override
    public void addConnectionEvtListener(IOEventListener listener) {
        this.ioListeners.addIfAbsent(listener);
    }

    @Override
    public void removeConnectionEvtListener(IOEventListener listener) {
        this.ioListeners.remove(listener);
    }

    @Override
    public List<IOEventListener> getConnectionEvtListeners() {
        return this.ioListeners;
    }

    public IOEventListener.ConnectionMsgReceivedListener getMsgReceivedListener() {
        return this.msgListener;
    }

    public IoSession getIoSession() {
        return this.session;
    }

    public void setLastRequestProtocol(byte lastRequestProtocol) {
        this.lastRequestProtocol = lastRequestProtocol;
    }

    @Override
    public byte lastRequestProtocol() {
        return this.lastRequestProtocol;
    }
}

