/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.impl;

import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoFuture;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoFutureListener;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.WriteFuture;
import com.taobao.remoting.Client;
import com.taobao.remoting.OverFlowWriteFuture;
import com.taobao.remoting.RemotingException;
import com.taobao.remoting.ResponseCallback;
import com.taobao.remoting.ResponseFuture;
import com.taobao.remoting.TRConstants;
import com.taobao.remoting.TimeoutException;
import com.taobao.remoting.impl.ConnectionRequest;
import com.taobao.remoting.impl.ConnectionResponse;
import com.taobao.remoting.impl.DefaultClient;
import com.taobao.remoting.impl.DefaultClientManager;
import com.taobao.remoting.locale.LogResources;
import com.taobao.remoting.util.DIYExecutor;
import com.taobao.remoting.util.LoggerInit;
import com.taobao.remoting.util.StringUtils;
import com.taobao.remoting.util.UnsafeCast;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class DefaultRespFuture
implements ResponseFuture {
    private volatile long waitBegin;
    private volatile boolean isDone = false;
    private volatile ConnectionResponse connResponse;
    private final ConnectionRequest connRequest;
    private ResponseCallback respCallback;
    private ScheduledFuture<?> timeoutFuture;
    private IoFutureListener writeFutureListener;

    DefaultRespFuture(ConnectionRequest _request) {
        this.connRequest = _request;
        this.writeFutureListener = new WFL();
    }

    @Override
    public long requestId() {
        return this.connRequest.getId();
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get() throws RemotingException, InterruptedException {
        DefaultRespFuture defaultRespFuture = this;
        synchronized (defaultRespFuture) {
            while (!this.isDone) {
                this.wait();
            }
        }
        return this.getResponseAfterDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(long timeout) throws RemotingException, TimeoutException, InterruptedException {
        if (timeout < 0L) {
            DefaultRespFuture defaultRespFuture = this;
            synchronized (defaultRespFuture) {
                while (!this.isDone) {
                    this.wait();
                }
            }
        }
        if (timeout > 0L) {
            long end = System.currentTimeMillis() + timeout;
            long waitTime = timeout;
            DefaultRespFuture defaultRespFuture = this;
            synchronized (defaultRespFuture) {
                while (!this.isDone && waitTime > 0L) {
                    this.wait(waitTime);
                    waitTime = end - System.currentTimeMillis();
                }
            }
        }
        if (!this.isDone) {
            return ResponseFuture.ASYN_NOT_DONE;
        }
        return this.getResponseAfterDone();
    }

    private Object getResponseAfterDone() throws RemotingException {
        int errorCode = this.connResponse.getResult();
        switch (errorCode) {
            case 0: {
                return this.connResponse.getAppResponse();
            }
            case 2: {
                String log = LogResources.getLog("respTimeout", new Object[0]);
                throw new TimeoutException(log);
            }
            case 4: {
                throw new RemotingException.WriteOverFlowException(this.connResponse.getErrorMsg(), (OverFlowWriteFuture)this.connResponse.getErrorCause());
            }
        }
        throw new RemotingException(this.connResponse.getErrorMsg());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponse(ConnectionResponse resp) {
        DefaultRespFuture defaultRespFuture = this;
        synchronized (defaultRespFuture) {
            this.connResponse = resp;
            this.isDone = true;
            this.notifyAll();
        }
        if (null != this.timeoutFuture) {
            this.timeoutFuture.cancel(true);
        }
        if (null != this.respCallback) {
            this.respCallback.getExecutor().execute(new CallBizCallback());
        }
        this.logIfResponseError(resp);
    }

    private void logIfResponseError(ConnectionResponse connResp) {
        if (0 == connResp.getResult()) {
            return;
        }
        try {
            String errorMsg = connResp.getErrorMsg();
            String errorStack = connResp.getErrorStack();
            long requestId = this.connRequest.getId();
            Object appRequest = this.connRequest.getAppRequest();
            String client = this.connRequest.getClient().toString();
            String msg = null;
            msg = StringUtils.isBlank(errorStack) ? LogResources.getLog("connectionRespError", requestId, client, appRequest, errorMsg) : LogResources.getLog("connectionRespErrorWithStack", requestId, client, appRequest, errorMsg, errorStack);
            LoggerInit.LOGGER.error(msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setRespCallback(ResponseCallback respCallback) {
        this.respCallback = respCallback;
    }

    public IoFutureListener getWriteFutureListener() {
        return this.writeFutureListener;
    }

    private class WFL
    implements IoFutureListener {
        private WFL() {
        }

        @Override
        public void operationComplete(IoFuture future) {
            WriteFuture wf = (WriteFuture)UnsafeCast.cast(future);
            if (wf.isWritten()) {
                DefaultClient client = (DefaultClient)DefaultRespFuture.this.connRequest.getClient();
                DefaultRespFuture.this.waitBegin = System.currentTimeMillis();
                client.addPendingRequest(DefaultRespFuture.this.connRequest);
                TimeoutHandle timeoutHandle = new TimeoutHandle();
                DefaultRespFuture.this.timeoutFuture = DefaultClientManager.timer.schedule(timeoutHandle, DefaultRespFuture.this.connRequest.getRespTimeout(), TimeUnit.MILLISECONDS);
            } else if (DefaultRespFuture.this.connRequest.getDirection() != 1) {
                byte protocol = DefaultRespFuture.this.connRequest.getSerializeProtocol();
                ConnectionResponse resp = new ConnectionResponse();
                resp.setRequestId(DefaultRespFuture.this.connRequest.getId());
                resp.setSerializeProtocol(protocol);
                resp.setResult(this.getErrorCode(wf));
                resp.setErrorMsg(LogResources.getLog("requestSendFail", TRConstants.getResultCodeMsg(resp.getResult()), wf.failStackTrace()));
                resp.setErrorCause(wf);
                DefaultRespFuture.this.setResponse(resp);
            }
        }

        private int getErrorCode(WriteFuture wf) {
            if (wf instanceof OverFlowWriteFuture) {
                return 4;
            }
            return 1;
        }
    }

    private class CallBizCallback
    implements Runnable {
        final Thread createThread = Thread.currentThread();

        CallBizCallback() {
        }

        @Override
        public void run() {
            if (this.createThread == Thread.currentThread() && DefaultRespFuture.this.respCallback.getExecutor() != DIYExecutor.getInstance()) {
                String msg = LogResources.getLog("ioThreadCannotCallback", DefaultRespFuture.this.connResponse.getRequestId());
                LoggerInit.LOGGER.warn(msg);
                return;
            }
            if (0 == DefaultRespFuture.this.connResponse.getResult()) {
                DefaultRespFuture.this.respCallback.handleResponse(DefaultRespFuture.this.connResponse.getAppResponse());
            } else if (DefaultRespFuture.this.respCallback instanceof ResponseCallback.ResponseCallbackExtends) {
                ((ResponseCallback.ResponseCallbackExtends)DefaultRespFuture.this.respCallback).onRemotingException(DefaultRespFuture.this.connResponse.getResult(), DefaultRespFuture.this.connResponse.getErrorMsg(), DefaultRespFuture.this.connResponse.getErrorCause());
            } else {
                DefaultRespFuture.this.respCallback.onRemotingException(DefaultRespFuture.this.connResponse.getResult(), DefaultRespFuture.this.connResponse.getErrorMsg());
            }
        }
    }

    private class TimeoutHandle
    implements Callable<Boolean> {
        private TimeoutHandle() {
        }

        @Override
        public Boolean call() {
            Client client = DefaultRespFuture.this.connRequest.getClient();
            ConnectionResponse resp = new ConnectionResponse();
            long waitMs = System.currentTimeMillis() - DefaultRespFuture.this.waitBegin;
            resp.setRequestId(DefaultRespFuture.this.connRequest.getId());
            resp.setResult(2);
            resp.setErrorMsg("\u54cd\u5e94\u8d85\u65f6[" + waitMs + "]ms.");
            boolean isok = client.putResponse(resp);
            return isok;
        }
    }
}

