/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.impl;

import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoAcceptor;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.ThreadModel;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.transport.socket.nio.SocketAcceptor;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import com.taobao.remoting.Connection;
import com.taobao.remoting.RemotingException;
import com.taobao.remoting.ResponseCallback;
import com.taobao.remoting.ResponseFuture;
import com.taobao.remoting.ResponseOfRequest;
import com.taobao.remoting.Server;
import com.taobao.remoting.impl.ConnectionResponse;
import com.taobao.remoting.impl.DefaultConnectionFactory;
import com.taobao.remoting.impl.DefaultIoHandler;
import com.taobao.remoting.impl.RequestControlImpl;
import com.taobao.remoting.locale.LogResources;
import com.taobao.remoting.util.LoggerInit;
import com.taobao.remoting.util.StringUtils;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executor;

public class DefaultServer
extends DefaultConnectionFactory
implements Server {
    private static final int BACKLOG_SIZE = 1024;
    final InetSocketAddress serverSocket;
    final IoAcceptor acceptor;
    private volatile boolean started = false;
    private volatile boolean stopped = false;
    final Random random = new Random();
    private volatile Server.GroupConnectionStrategy connSelector = new RandomConnectionStrategy();

    public DefaultServer(int _port) {
        this(null, _port);
    }

    public DefaultServer(String _bindIP, int _port) {
        this.serverSocket = StringUtils.isBlank(_bindIP) ? new InetSocketAddress(_port) : new InetSocketAddress(_bindIP, _port);
        this.acceptor = new SocketAcceptor(processorCount, IO_THREAD_POOL);
        SocketAcceptorConfig cfg = (SocketAcceptorConfig)this.acceptor.getDefaultConfig();
        cfg.setBacklog(1024);
        cfg.setThreadModel(ThreadModel.MANUAL);
        cfg.getFilterChain().addLast("objectserialize", CODEC_FILTER);
    }

    @Override
    public synchronized void start() throws RemotingException {
        if (this.stopped) {
            LoggerInit.LOGGER.error("\u4e0d\u80fd\u542f\u52a8\u5df2\u7ecf\u5173\u95ed\u7684DefaultServer");
        }
        if (this.started) {
            return;
        }
        DefaultIoHandler ioHandler = new DefaultIoHandler(this);
        try {
            this.acceptor.bind(this.serverSocket, ioHandler);
            this.started = true;
            LoggerInit.LOGGER.warn("\u670d\u52a1\u5668\u5df2\u542f\u52a8\uff1a" + this.serverSocket);
        }
        catch (Exception e) {
            throw new RemotingException("\u542f\u52a8Server\u5931\u8d25", e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                DefaultServer.this.stop();
            }
        });
    }

    @Override
    public synchronized void stop() {
        this.started = false;
        this.stopped = true;
        this.acceptor.unbindAll();
        LoggerInit.LOGGER.warn("\u670d\u52a1\u5668\u5df2\u505c\u6b62\u8fd0\u884c\uff1a" + this.serverSocket);
    }

    @Override
    public void sendToGroups(final Map<String, Object> groupDatas, final ResponseCallback.GroupRandomResponseCallback callback, long timeout, final Object ... callbackArgs) throws RemotingException {
        final HashMap responses = new HashMap();
        for (Map.Entry<String, Object> tmp : groupDatas.entrySet()) {
            final String group = tmp.getKey();
            Object data = tmp.getValue();
            Connection connection = this.connSelector.getConnection(group);
            final String remoteIp = null != connection ? connection.getRemoteAddress() : null;
            final int remotePort = null != connection ? connection.getRemotePort() : -1;
            ResponseCallback innerCallback = new ResponseCallback(){

                @Override
                public Executor getExecutor() {
                    return callback.getExecutor();
                }

                @Override
                public void handleResponse(Object appResp) {
                    this.onGroupResponse(new ResponseOfRequest(appResp, remoteIp, remotePort));
                }

                @Override
                public void onRemotingException(int errorType, String errorMsg) {
                    this.onGroupResponse(new ResponseOfRequest(errorType, errorMsg, remoteIp, remotePort));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void onGroupResponse(ResponseOfRequest groupResp) {
                    Map map = responses;
                    synchronized (map) {
                        responses.put(group, groupResp);
                        if (responses.size() == groupDatas.size()) {
                            callback.handleResponses(responses, callbackArgs);
                        }
                    }
                }
            };
            if (null != connection) {
                RequestControlImpl control = new RequestControlImpl(1, timeout);
                connection.getClient().invokeWithCallback(data, innerCallback, control);
                continue;
            }
            ConnectionResponse response = new ConnectionResponse();
            response.setResult(3);
            innerCallback.onRemotingException(3, LogResources.getLog("server_group_empty", group));
        }
    }

    @Override
    public void sendToGroupOneway(String group, Object payloadObject) throws RemotingException {
        Connection connection = this.connSelector.getConnection(group);
        if (connection == null) {
            throw new RemotingException(LogResources.getLog("server_group_empty", group));
        }
        RequestControlImpl control = new RequestControlImpl(1);
        connection.getClient().oneway(payloadObject, control);
    }

    @Override
    public void sendToGroupAllOneway(String group, Object payload, byte protocol) {
        RequestControlImpl control = new RequestControlImpl(protocol);
        for (Connection conn : this.groupConnectionSnapshot(group)) {
            conn.getClient().oneway(payload, control);
        }
    }

    @Override
    public void sendToGroupAllCallback(String group, Object payload, ResponseCallback.MultiResponseCallback totalCallback, byte protocol, long waitTimeoutMs) {
        List<Connection> conns = this.groupConnectionSnapshot(group);
        ConnectionsWithOneCallback help = new ConnectionsWithOneCallback(conns, totalCallback);
        for (Connection conn : conns) {
            RequestControlImpl control = new RequestControlImpl(protocol, waitTimeoutMs);
            conn.getClient().invokeWithCallback(payload, help.getConnectionCallback(conn), control);
        }
    }

    @Override
    public ResponseFuture invokeWithFuture(Object appRequest, Connection connection, long waitTimeoutMs, byte protocol) throws RemotingException {
        RequestControlImpl control = new RequestControlImpl(protocol, waitTimeoutMs);
        return connection.getClient().invokeWithFuture(appRequest, control);
    }

    @Override
    public int getPort() {
        return this.serverSocket.getPort();
    }

    @Override
    public String getBindIp() {
        return this.serverSocket.getAddress().getHostAddress();
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    private Connection randomGetConnectionByGroup(String group) {
        List<Connection> connections = this.groupConnectionSnapshot(group);
        if (connections.isEmpty()) {
            return null;
        }
        if (connections.size() == 1) {
            return (Connection)connections.iterator().next();
        }
        Connection[] connectionsArray = new Connection[connections.size()];
        connectionsArray = connections.toArray(connectionsArray);
        return connectionsArray[this.random.nextInt(connections.size())];
    }

    @Override
    public void setGroupConnectionStrategy(Server.GroupConnectionStrategy strategy) {
        if (null == strategy) {
            throw new IllegalArgumentException();
        }
        this.connSelector = strategy;
    }

    private class RandomConnectionStrategy
    implements Server.GroupConnectionStrategy {
        private RandomConnectionStrategy() {
        }

        @Override
        public Connection getConnection(String groupName) {
            return DefaultServer.this.randomGetConnectionByGroup(groupName);
        }
    }

    static class ConnectionsWithOneCallback {
        final Collection<Connection> connections;
        final ResponseCallback.MultiResponseCallback totalCallback;
        final Map<Connection, ResponseCallback> conn2callback;
        final Map<Connection, ResponseOfRequest> appResponses;

        public ConnectionsWithOneCallback(Collection<Connection> _conns, ResponseCallback.MultiResponseCallback _totalCallback) {
            this.connections = _conns;
            this.totalCallback = _totalCallback;
            this.conn2callback = new HashMap<Connection, ResponseCallback>();
            this.appResponses = new HashMap<Connection, ResponseOfRequest>();
            for (final Connection conn : _conns) {
                this.conn2callback.put(conn, new ResponseCallback(){

                    @Override
                    public Executor getExecutor() {
                        return ConnectionsWithOneCallback.this.totalCallback.getExecutor();
                    }

                    @Override
                    public void handleResponse(Object appResponse) {
                        this.onCallback(new ResponseOfRequest(appResponse, conn.getRemoteAddress(), conn.getRemotePort()));
                    }

                    @Override
                    public void onRemotingException(int errorType, String errorMsg) {
                        this.onCallback(new ResponseOfRequest(errorType, errorMsg, conn.getRemoteAddress(), conn.getRemotePort()));
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void onCallback(ResponseOfRequest resp) {
                        Map<Connection, ResponseOfRequest> map = ConnectionsWithOneCallback.this.appResponses;
                        synchronized (map) {
                            ConnectionsWithOneCallback.this.appResponses.put(conn, resp);
                            if (ConnectionsWithOneCallback.this.appResponses.size() == ConnectionsWithOneCallback.this.connections.size()) {
                                ConnectionsWithOneCallback.this.totalCallback.onMultiResponse(new ArrayList<ResponseOfRequest>(ConnectionsWithOneCallback.this.appResponses.values()));
                            }
                        }
                    }
                });
            }
        }

        public ResponseCallback getConnectionCallback(Connection connection) {
            return this.conn2callback.get(connection);
        }
    }
}

