/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.impl;

import com.taobao.remoting.IOEventListener;
import com.taobao.remoting.RequestProcessor;
import com.taobao.remoting.Server;
import com.taobao.remoting.ServerManager;
import com.taobao.remoting.impl.DefaultServer;
import com.taobao.remoting.util.LoggerInit;
import com.taobao.remoting.util.ResourceInvalidException;
import com.taobao.remoting.util.SharedResourcesInit;
import com.taobao.remoting.util.UnsafeCast;
import java.util.List;
import java.util.Map;

public class DefaultServerManager
implements ServerManager {
    private ServerRepo serverRepo = new ServerRepo();

    @Override
    public Server getServer(String bindIp, int port, List<IOEventListener> listeners, List<RequestProcessor<?>> processors) {
        String serverKey = DefaultServerManager.getServerKey(bindIp, port);
        Object[] attach = new Object[]{listeners, processors};
        Server server = null;
        try {
            server = (Server)this.serverRepo.getResource(serverKey, attach);
        }
        catch (Exception e) {
            LoggerInit.LOGGER.warn("\u53d6Server[" + serverKey + "]\u65f6\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), e);
        }
        return server;
    }

    Map<String, Server> serversSnapshot() {
        Map<String, Server> servers = null;
        try {
            servers = this.serverRepo.resourcesSnapshot();
        }
        catch (Exception e) {
            LoggerInit.LOGGER.warn(e.getMessage(), e);
        }
        return servers;
    }

    private static String getServerKey(String bindIp, int port) {
        String ip = null == bindIp ? "" : bindIp;
        return ip + "#" + port;
    }

    private static Object[] parseServerKey(String key) {
        String[] tokens = key.split("#");
        return new Object[]{tokens[0], Integer.parseInt(tokens[1])};
    }

    private static class ServerRepo
    extends SharedResourcesInit<Server> {
        private ServerRepo() {
        }

        @Override
        protected boolean isSingletonResource() {
            return false;
        }

        @Override
        protected Server keyedInitResource(String key, Object attachment) throws Exception {
            Object[] tmp = DefaultServerManager.parseServerKey(key);
            String bindIp = (String)UnsafeCast.cast(tmp[0]);
            int port = (Integer)tmp[1];
            DefaultServer server = new DefaultServer(bindIp, port);
            if (null != attachment) {
                Object[] attach = (Object[])attachment;
                if (null != attach[0]) {
                    List listeners = (List)UnsafeCast.cast(attach[0]);
                    for (IOEventListener listener : listeners) {
                        server.addListener(listener);
                    }
                }
                if (null != attach[1]) {
                    List processors = (List)UnsafeCast.cast(attach[1]);
                    for (RequestProcessor processor : processors) {
                        server.registerProcessor(processor);
                    }
                }
            }
            return server;
        }

        @Override
        protected void validate(Server resource) throws ResourceInvalidException {
            if (((DefaultServer)resource).isStopped()) {
                throw new ResourceInvalidException("server closed");
            }
        }
    }
}

