/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.impl;

import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IdleStatus;
import com.taobao.remoting.Connection;
import com.taobao.remoting.RequestProcessor;
import com.taobao.remoting.impl.ConnectionHeartBeat;
import com.taobao.remoting.impl.DefaultConnection;
import com.taobao.remoting.util.ConnectionUrl;
import com.taobao.remoting.util.DIYExecutor;
import java.util.concurrent.Executor;

public class HeartBeatProcessor
implements RequestProcessor<ConnectionHeartBeat> {
    private static final byte HEARTBEAT_RESPONSE = 1;
    public static final HeartBeatProcessor instance = new HeartBeatProcessor();

    @Override
    public void handleRequest(ConnectionHeartBeat appRequest, RequestProcessor.AppResponseOutput respOut) {
        String clientUrl = appRequest.getClientUrl();
        if (null != clientUrl) {
            Connection conn = respOut.getConnection();
            conn.setAttribute("ClientUrl", clientUrl);
            int idleTime = ConnectionUrl.getIdleTimeout(clientUrl);
            if (0 < idleTime) {
                ((DefaultConnection)conn).getIoSession().setIdleTime(IdleStatus.READER_IDLE, idleTime);
            }
        }
        respOut.write((byte)1);
    }

    @Override
    public Class<ConnectionHeartBeat> interest() {
        return ConnectionHeartBeat.class;
    }

    @Override
    public Executor getExecutor() {
        return DIYExecutor.getInstance();
    }

    @Override
    public void onRejectedExecutionException(ConnectionHeartBeat appRequest, RequestProcessor.AppResponseOutput respOut) {
    }

    public static String clientTargetUrl(Connection conn) {
        if (conn.isClientSide()) {
            return null;
        }
        return (String)conn.getAttribute("ClientUrl");
    }
}

