/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.impl;

import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoSession;
import com.taobao.remoting.SessionsFlushQueueListener;
import com.taobao.remoting.impl.DefaultClientManager;
import com.taobao.remoting.impl.DefaultConnection;
import com.taobao.remoting.impl.LCL_AliveSessionsListener;
import com.taobao.remoting.spi.SessionsFlushQueueService;
import com.taobao.remoting.util.LoggerInit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

class SessionsFlushQueueServiceImpl
implements SessionsFlushQueueService {
    private final List<SessionsFlushQueueListener> listeners = new ArrayList<SessionsFlushQueueListener>();

    SessionsFlushQueueServiceImpl() {
        DefaultClientManager.timer.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    SessionsFlushQueueServiceImpl.this.calculatePileUpAndNotifyListeners();
                }
                catch (Throwable e) {
                    LoggerInit.LOGGER.error(e.toString(), e);
                }
            }
        }, 0L, 5L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFlushQueueListener(SessionsFlushQueueListener listener) {
        List<SessionsFlushQueueListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFlushQueueListener(SessionsFlushQueueListener listener) {
        List<SessionsFlushQueueListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    private void calculatePileUpAndNotifyListeners() {
        long totalPileUp = 0L;
        DefaultConnection mostPileUpConn = null;
        for (DefaultConnection conn : LCL_AliveSessionsListener.aliveSessions()) {
            IoSession session = conn.getSession();
            totalPileUp += (long)session.getScheduledWriteBytes();
            if (null == mostPileUpConn) {
                mostPileUpConn = conn;
                continue;
            }
            if (session.getScheduledWriteBytes() <= mostPileUpConn.getSession().getScheduledWriteBytes()) continue;
            mostPileUpConn = conn;
        }
        for (SessionsFlushQueueListener listener : this.listeners) {
            try {
                long maxPileUp = null == mostPileUpConn ? 0L : (long)mostPileUpConn.getSession().getScheduledWriteBytes();
                listener.allSessionScheduledWriteByteIs(totalPileUp, maxPileUp, mostPileUpConn);
            }
            catch (Exception e) {
                LoggerInit.LOGGER.warn(e.toString(), e);
            }
        }
    }
}

