/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.impl.socks;

import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.ByteBuffer;
import com.taobao.remoting.impl.NetUtil;
import com.taobao.remoting.impl.socks.SocksRequestPackage;
import java.io.UnsupportedEncodingException;

public class SocksCmdRequest
implements SocksRequestPackage {
    public int version;
    public int cmd;
    public int rsv;
    public int atype;
    public String addr;
    public int port;

    @Override
    public void encode(ByteBuffer buf) {
        buf.put((byte)this.version);
        buf.put((byte)this.cmd);
        buf.put((byte)this.rsv);
        buf.put((byte)this.atype);
        if (this.atype == 1) {
            if (this.addr != null) {
                byte[] bytes = NetUtil.validIpV4ToBytes(this.addr);
                buf.put(bytes);
            } else {
                buf.putInt(0);
            }
        } else if (this.atype == 4) {
            if (this.addr != null) {
                buf.put(NetUtil.createByteArrayFromIpAddressString(this.addr));
            } else {
                buf.putLong(0L);
                buf.putLong(0L);
            }
        } else if (this.atype == 3) {
            if (this.addr != null) {
                buf.put((byte)this.addr.length());
                try {
                    buf.put(this.addr.getBytes("ISO8859-1"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
            } else {
                buf.put((byte)1);
                buf.put((byte)0);
            }
        }
        buf.putShort((short)this.port);
    }

    public String toString() {
        return "SocksCmdRequest [version=" + this.version + ", cmd=" + this.cmd + ", rsv=" + this.rsv + ", atype=" + this.atype + ", addr=" + this.addr + ", port=" + this.port + "]";
    }
}

