/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.serialize;

import com.alibaba.cs.shaded.com.alibaba.configserver.com.caucho.hessian.io.HessianInput;
import com.alibaba.cs.shaded.com.alibaba.configserver.com.caucho.hessian.io.HessianOutput;
import com.taobao.remoting.Remoting;
import com.taobao.remoting.serialize.CustomSerialization;
import com.taobao.remoting.serialize.SerialDataReusable;
import com.taobao.remoting.serialize.impl.SliceOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.WeakHashMap;

public class DefaultSerialization
implements CustomSerialization<Object> {
    public static final DefaultSerialization instance = new DefaultSerialization();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(Object msg, byte protocol, OutputStream bout) throws IOException {
        switch (protocol) {
            case 1: {
                DefaultSerialization.createHessianOutput(bout).writeObject(msg);
                return;
            }
            case 2: 
            case 3: {
                ObjectOutputStream javaOutput = null;
                javaOutput = Remoting.serialUtil().isReuseSerialization() ? new JavaObjectOutputStream(bout) : new ObjectOutputStream(bout);
                try {
                    javaOutput.writeObject(msg);
                    javaOutput.flush();
                    return;
                }
                finally {
                    javaOutput.close();
                }
            }
        }
        throw new IllegalArgumentException("\u4e0d\u53ef\u8bc6\u522b\u7684\u5e8f\u5217\u5316\u534f\u8bae: " + protocol);
    }

    @Override
    public Object deserialize(InputStream is, byte protocol) throws IOException {
        switch (protocol) {
            case 1: {
                try {
                    HessianInput hin = DefaultSerialization.createHessianInput(is);
                    return hin.readObject();
                }
                catch (IOException ioe) {
                    IOException newIoe = new IOException(ioe.getMessage() + ", " + HessianInput.class.getResource("HessianInput.class"));
                    newIoe.setStackTrace(ioe.getStackTrace());
                    throw newIoe;
                }
            }
            case 2: 
            case 3: {
                ObjectInputStream javaInput = new ObjectInputStream(is);
                try {
                    Object newIoe = javaInput.readObject();
                    return newIoe;
                }
                catch (ClassNotFoundException ex) {
                    throw new IOException("ClassNotFoundException:" + ex.getMessage(), ex.getCause());
                }
                finally {
                    javaInput.close();
                }
            }
        }
        throw new IllegalArgumentException("\u4e0d\u53ef\u8bc6\u522b\u7684\u5e8f\u5217\u5316\u534f\u8bae: " + protocol);
    }

    public static HessianOutput createHessianOutput(OutputStream out) {
        HessianOutput hout = Remoting.serialUtil().isReuseSerialization() ? new HessianObjectOutputStream(out) : new HessianOutput(out);
        hout.setSerializerFactory(Remoting.serialUtil().getHessianSerializerFactory());
        return hout;
    }

    public static HessianInput createHessianInput(InputStream in) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl == null) {
            Thread.currentThread().setContextClassLoader(DefaultSerialization.class.getClassLoader());
        }
        HessianInput hin = new HessianInput(in);
        hin.setSerializerFactory(Remoting.serialUtil().getHessianSerializerFactory());
        return hin;
    }

    public <T> T hessianReadObject(InputStream is, Class<T> type) throws IOException {
        try {
            HessianInput hin = DefaultSerialization.createHessianInput(is);
            return (T)hin.readObject(type);
        }
        catch (IOException ioe) {
            IOException newIoe = new IOException(ioe.getMessage() + ", " + HessianInput.class.getResource("HessianInput.class"));
            newIoe.setStackTrace(ioe.getStackTrace());
            throw newIoe;
        }
    }

    private static class HessianObjectOutputStream
    extends HessianOutput {
        private static WeakHashMap<SerialDataReusable, byte[]> reuseSerialCache = new WeakHashMap();

        public HessianObjectOutputStream(OutputStream _os) {
            super(_os);
        }

        @Override
        public void writeObject(Object object) throws IOException {
            if (!(object instanceof SerialDataReusable)) {
                super.writeObject(object);
                return;
            }
            SerialDataReusable reuseSerialObj = (SerialDataReusable)object;
            byte[] reuseSerial = reuseSerialCache.get(reuseSerialObj);
            if (null == reuseSerial) {
                ByteArrayOutputStream binary = new ByteArrayOutputStream();
                HessianOutput hout = new HessianOutput(binary);
                hout.setSerializerFactory(Remoting.serialUtil().getHessianSerializerFactory());
                hout.writeObject(object);
                reuseSerial = binary.toByteArray();
                reuseSerialCache.put(reuseSerialObj, reuseSerial);
            }
            if (this.os instanceof SliceOutputStream) {
                ((SliceOutputStream)this.os).addSlice(reuseSerial);
            } else {
                this.os.write(reuseSerial);
            }
        }
    }

    private static class JavaObjectOutputStream
    extends ObjectOutputStream {
        private static WeakHashMap<SerialDataReusable, byte[]> reuseSerialCache = new WeakHashMap();
        private final OutputStream os;
        private final ObjectOutputStream delegate;

        JavaObjectOutputStream(OutputStream _os) throws IOException {
            this.os = _os;
            this.delegate = new ObjectOutputStream(this.os);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        protected void writeObjectOverride(Object obj) throws IOException {
            if (!(obj instanceof SerialDataReusable)) {
                this.delegate.writeObject(obj);
                return;
            }
            SerialDataReusable reuseSerialObj = (SerialDataReusable)obj;
            byte[] reuseSerial = reuseSerialCache.get(reuseSerialObj);
            this.delegate.flush();
            if (null == reuseSerial) {
                ByteArrayOutputStream binary = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(binary){

                    @Override
                    protected void writeStreamHeader() throws IOException {
                    }
                };
                oos.writeObject(reuseSerialObj);
                oos.flush();
                oos.close();
                reuseSerial = binary.toByteArray();
                reuseSerialCache.put(reuseSerialObj, reuseSerial);
            }
            if (this.os instanceof SliceOutputStream) {
                ((SliceOutputStream)this.os).addSlice(reuseSerial);
            } else {
                this.os.write(reuseSerial);
            }
        }
    }
}

