/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.serialize.impl;

import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.ByteBuffer;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoSession;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.filter.codec.ProtocolEncoderOutput;
import com.taobao.remoting.Remoting;
import com.taobao.remoting.impl.ConnectionRequest;
import com.taobao.remoting.impl.ConnectionResponse;
import com.taobao.remoting.serialize.impl.ConnRequestSerialization;
import com.taobao.remoting.serialize.impl.ConnResponseSerialization;
import com.taobao.remoting.serialize.impl.SliceOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RemotingProtocolEncoder
extends ProtocolEncoderAdapter {
    private ConnRequestSerialization reqSerialize = new ConnRequestSerialization();
    private ConnResponseSerialization rspSerialize = new ConnResponseSerialization();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        byte protocol;
        boolean isRequest = message instanceof ConnectionRequest;
        boolean isResponse = message instanceof ConnectionResponse;
        if (!isRequest && !isResponse) {
            throw new IOException("\u4e0d\u53ef\u8bc6\u522b\u7684\u5e8f\u5217\u5316\u5bf9\u8c61: " + message);
        }
        SliceOutputStream os = new SliceOutputStream();
        if (isRequest) {
            ConnectionRequest connectionRequest = (ConnectionRequest)message;
            protocol = connectionRequest.getSerializeProtocol();
            this.reqSerialize.serialize(connectionRequest, protocol, (OutputStream)os);
        } else {
            ConnectionResponse connectionResponse = (ConnectionResponse)message;
            protocol = connectionResponse.getSerializeProtocol();
            this.rspSerialize.serialize(connectionResponse, protocol, (OutputStream)os);
        }
        for (byte[] slice : os.allSlices()) {
            out.write(ByteBuffer.wrap(slice));
        }
        if (Remoting.serialUtil().isReuseSerialization()) {
            IoSession ioSession = session;
            synchronized (ioSession) {
                out.flush();
            }
        }
    }
}

