/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteBufferUtil {
    public static InputStream asInputStream(ByteBuffer buf) {
        return new ByteBufferAdapter2InputStream(buf);
    }

    public static OutputStream asOutputStream(final ByteBuffer buf) {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                buf.put((byte)b);
            }

            @Override
            public void write(byte[] bytes, int off, int len) throws IOException {
                buf.put(bytes, off, len);
            }
        };
    }

    private static class ByteBufferAdapter2InputStream
    extends InputStream {
        private ByteBuffer bb;

        ByteBufferAdapter2InputStream(ByteBuffer _bb) {
            this.bb = _bb;
        }

        @Override
        public int read() throws IOException {
            return this.bb.hasRemaining() ? this.bb.get() & 0xFF : -1;
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            len = Math.min(len, this.bb.remaining());
            this.bb.get(bytes, off, len);
            return len;
        }

        @Override
        public long skip(long n) {
            if ((long)this.bb.position() + n > (long)this.bb.limit()) {
                n = this.bb.limit() - this.bb.position();
            }
            if (n < 0L) {
                return 0L;
            }
            this.bb.position((int)((long)this.bb.position() + n));
            return n;
        }

        @Override
        public int available() {
            return this.bb.limit() - this.bb.position();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readlimit) {
            this.bb.mark();
        }

        @Override
        public void reset() {
            this.bb.reset();
        }
    }
}

