/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.util;

import java.lang.ref.SoftReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class ConnectionUrl {
    static ConcurrentHashMap<String, SoftReference<ConnectionUrl>> parsedUrls = new ConcurrentHashMap();
    static volatile boolean isCollected = false;
    private final String origonalURL;
    private final String formatedURL;
    private final int hashcode;
    private String targetAddr;
    private String targetAddrIP;
    private int targetPort;
    private TreeMap<String, String> connectProps = new TreeMap();

    public static ConnectionUrl get(String url) {
        ConnectionUrl urlObject;
        SoftReference<ConnectionUrl> softRef = parsedUrls.get(url);
        ConnectionUrl connectionUrl = urlObject = null == softRef ? null : softRef.get();
        if (null != urlObject) {
            return urlObject;
        }
        ConnectionUrl returnObject = new ConnectionUrl(url);
        parsedUrls.put(url, new SoftReference<ConnectionUrl>(returnObject));
        return returnObject;
    }

    public static long getConnectTimeout(String url) {
        ConnectionUrl urlObj = ConnectionUrl.get(url);
        return Long.parseLong(urlObj.getProperty("_CONNECTTIMEOUT"));
    }

    public static long getReadTimeout(String url) {
        ConnectionUrl urlObj = ConnectionUrl.get(url);
        return Long.parseLong(urlObj.getProperty("_TIMEOUT"));
    }

    public static int getIdleTimeout(String url) {
        ConnectionUrl urlObj = ConnectionUrl.get(url);
        return Integer.parseInt(urlObj.getProperty("_IDLETIMEOUT"));
    }

    public static int getMaxReadIdle(String url) {
        ConnectionUrl urlObj = ConnectionUrl.get(url);
        return Integer.parseInt(urlObj.getProperty("_MAXREADIDLETIME"));
    }

    public static byte getSerializeProtocol(String url) {
        ConnectionUrl urlObj = ConnectionUrl.get(url);
        return Byte.parseByte(urlObj.getProperty("_SERIALIZETYPE"));
    }

    public static boolean isAutoReconnect(String url) {
        ConnectionUrl urlObj = ConnectionUrl.get(url);
        return Boolean.parseBoolean(urlObj.getProperty("_AUTORECONNECT"));
    }

    public static InetSocketAddress socketAddr(String url) {
        ConnectionUrl targetUrl = ConnectionUrl.get(url);
        return new InetSocketAddress(targetUrl.getTargetAddr(), targetUrl.getTargetPort());
    }

    static int cachedInstanceCount() {
        return parsedUrls.size();
    }

    static void clearCachedUrls() {
        parsedUrls.clear();
    }

    protected void finalize() {
        isCollected = true;
        parsedUrls.remove(this.origonalURL);
    }

    private ConnectionUrl(String url) {
        if (url == null) {
            throw new IllegalArgumentException("\u4f20\u5165ConnectionUrl\u6784\u9020\u51fd\u6570\u7684\u53c2\u6570\u4e3aNULL.");
        }
        this.origonalURL = url;
        this.putProp("_CONNECTTIMEOUT", String.valueOf(1000L));
        this.putProp("_IDLETIMEOUT", String.valueOf(10L));
        this.putProp("_AUTORECONNECT", String.valueOf(false));
        this.putProp("_AUTORECONNECT_SLEEPTIME", String.valueOf(1000L));
        this.putProp("_HEARBEAT", String.valueOf(false));
        this.putProp("_CONNECTIONNUM", String.valueOf(1));
        this.putProp("_TIMEOUT", String.valueOf(3000L));
        this.putProp("_MAXREADIDLETIME", "30");
        int firstSep = url.indexOf(":");
        if (firstSep <= 0) {
            throw new IllegalArgumentException("ConnectionUrl\u6784\u9020\u51fd\u6570\u53c2\u6570\u9519\u8bef: " + url);
        }
        this.targetAddr = url.substring(0, firstSep);
        try {
            this.targetAddrIP = InetAddress.getByName(this.targetAddr).getHostAddress();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        int secondSep = url.indexOf("?");
        if (secondSep > 0) {
            this.targetPort = Integer.parseInt(url.substring(firstSep + 1, secondSep));
            String propsString = url.substring(secondSep + 1);
            String[] props = propsString.split("&");
            for (int i = 0; i < props.length; ++i) {
                String[] propPair = props[i].split("=");
                this.putProp(propPair[0].toUpperCase(), propPair[1]);
            }
        } else {
            this.targetPort = Integer.parseInt(url.substring(firstSep + 1));
        }
        if (null == this.connectProps.get("_SERIALIZETYPE")) {
            this.putProp("_SERIALIZETYPE", String.valueOf(1));
        }
        this.formatedURL = ConnectionUrl.toURL(this.targetAddr, this.targetPort, this.connectProps);
        this.hashcode = this.formatedURL.hashCode();
    }

    private void putProp(String k, String v) {
        this.connectProps.put(k, v);
    }

    public String getTargetAddr() {
        return this.targetAddr;
    }

    public String getTargetAddrIP() {
        return this.targetAddrIP;
    }

    public int getTargetPort() {
        return this.targetPort;
    }

    public String getProperty(String propertyName) {
        return this.connectProps.get(propertyName.toUpperCase());
    }

    public TreeMap<String, String> getProperties() {
        return this.connectProps;
    }

    public String toString() {
        return this.formatedURL;
    }

    public static String toURL(String ip, int port, Map<String, String> prop) {
        StringBuilder sb = new StringBuilder();
        sb.append(ip).append(":").append(port).append("?");
        for (Map.Entry<String, String> entry : prop.entrySet()) {
            sb.append(entry.getKey().toUpperCase());
            sb.append("=");
            sb.append(entry.getValue());
            sb.append("&");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static String replaceProperty(String url, String key, String value) {
        StringBuilder sb = new StringBuilder(url);
        int keyIdx = url.indexOf(key);
        int questionIdx = url.indexOf(63);
        if (keyIdx < 0) {
            sb.append(questionIdx < 0 ? "?" : "&");
            sb.append(key).append("=").append(value);
            return sb.toString();
        }
        int startIdx = keyIdx + key.length() + 1;
        int endIdx = url.indexOf(38, startIdx);
        if (endIdx < 0) {
            sb.replace(startIdx, url.length(), value);
        } else {
            sb.replace(startIdx, endIdx, value);
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionUrl another = (ConnectionUrl)obj;
        return this.toString().equals(another.toString());
    }

    public static boolean isLocalhost(String host) {
        return "127.0.0.1".equals(host) || "localhost".equalsIgnoreCase(host);
    }

    public static String localhostRealIP() {
        String realIP = null;
        try {
            realIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return realIP;
    }

    public static void main(String[] args) {
        ConnectionUrl url = ConnectionUrl.get("192.168.207.169:9600?_SERIALIZETYPE=2&_AUTORECONNECT=false&_HEARBEAT=true&_IDLETIMEOUT=5&_CONNECTTIMEOUT=5000&_TIMEOUT=3000&SCRAP=0");
        System.out.println(url.getProperty("_SERIALIZETYPE"));
    }
}

