/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.util;

import com.taobao.remoting.util.RemotingProfilerMBean;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class RemotingProfiler
implements RemotingProfilerMBean {
    public static volatile boolean enable;
    private static final ThreadLocal<Entry> entryStack;

    public static void set(Entry entry) {
        if (null != entry) {
            entryStack.set(entry);
        }
    }

    public static void start(String message) {
        entryStack.set(enable ? new Entry(null, message) : new EntryMock());
    }

    public static void enter(String message) {
        if (RemotingProfiler.isMockTrace()) {
            return;
        }
        Entry currentEntry = RemotingProfiler.getCurrentEntry();
        if (currentEntry != null) {
            currentEntry.enterSubEntry(message);
        }
    }

    public static void release(String expectedMsg) {
        if (RemotingProfiler.isMockTrace()) {
            return;
        }
        Entry currentEntry = RemotingProfiler.getCurrentEntry();
        if (null != currentEntry && currentEntry.getMessage().equals(expectedMsg)) {
            currentEntry.release();
        }
    }

    public static void reset() {
        entryStack.set(null);
    }

    public static void addSubTrace(Entry subTree) {
        if (RemotingProfiler.isMockTrace()) {
            return;
        }
        Entry currentEntry = RemotingProfiler.getCurrentEntry();
        if (null == currentEntry || null == subTree) {
            return;
        }
        RemotingProfiler.copyTree(currentEntry, subTree);
    }

    private static void copyTree(Entry current, Entry tree) {
        Entry copy = new Entry(current, tree.message, tree.startTime, tree.endTime);
        current.subEntries.add(copy);
        for (Entry child : tree.subEntries) {
            RemotingProfiler.copyTree(copy, child);
        }
    }

    public static long getDuration() {
        Entry entry = entryStack.get();
        return entry != null ? entry.getDuration() : -1L;
    }

    public static Entry getEntry() {
        return entryStack.get();
    }

    protected static Entry getCurrentEntry() {
        Entry subEntry = entryStack.get();
        Entry entry = null;
        if (subEntry != null) {
            while ((subEntry = (entry = subEntry).getUnreleasedEntry()) != null) {
            }
        }
        return entry;
    }

    public static String dump() {
        return RemotingProfiler.dump("", "");
    }

    public static String dump(String prefix) {
        return RemotingProfiler.dump(prefix, prefix);
    }

    public static String dump(String prefix1, String prefix2) {
        if (RemotingProfiler.isMockTrace()) {
            return "";
        }
        Entry entry = entryStack.get();
        if (entry != null) {
            return entry.toString(prefix1, prefix2);
        }
        return "";
    }

    public static boolean isMockTrace() {
        Entry entry = entryStack.get();
        return null != entry && entry instanceof EntryMock;
    }

    @Override
    public void enableProfiler() {
        enable = true;
    }

    @Override
    public void disableProfiler() {
        enable = false;
    }

    @Override
    public boolean isEnableProfiler() {
        return enable;
    }

    static {
        ClassLoader oldTCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(RemotingProfiler.class.getClassLoader());
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName("tbremoting:name=profiler");
            if (!mbs.isRegistered(objectName)) {
                mbs.registerMBean(new RemotingProfiler(), objectName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTCL);
        }
        enable = false;
        entryStack = new ThreadLocal();
    }

    public static final class EntryMock
    extends Entry {
        private static final long serialVersionUID = 1L;

        protected EntryMock() {
            super(null, "");
            this.endTime = System.currentTimeMillis();
        }

        @Override
        protected String getMessage() {
            return "";
        }

        @Override
        protected void release() {
        }

        @Override
        protected void enterSubEntry(String message) {
        }

        @Override
        protected Entry deepClone() {
            return this;
        }
    }

    public static class Entry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final Entry parent;
        protected final Entry root;
        protected final List<Entry> subEntries = new ArrayList<Entry>(4);
        protected final String message;
        protected final long baseTime;
        protected final long startTime;
        protected long endTime;

        protected Entry(Entry parentEntry, String message) {
            this.message = message;
            this.startTime = System.currentTimeMillis();
            this.parent = parentEntry;
            this.root = null == this.parent ? this : this.parent.root;
            this.baseTime = null == this.parent ? 0L : this.root.startTime;
        }

        protected Entry(Entry parentEntry, String message, long _startTime, long _endTime) {
            this.message = message;
            this.startTime = _startTime;
            this.endTime = _endTime;
            this.parent = parentEntry;
            this.root = null == this.parent ? this : this.parent.root;
            this.baseTime = null == this.parent ? 0L : this.root.startTime;
        }

        protected String getMessage() {
            return this.message;
        }

        protected long getStartTime() {
            return this.baseTime > 0L ? this.startTime - this.baseTime : 0L;
        }

        protected long getEndTime() {
            if (this.endTime < this.baseTime) {
                return -1L;
            }
            return this.endTime - this.baseTime;
        }

        protected long getDuration() {
            if (this.endTime < this.startTime) {
                return -1L;
            }
            return this.endTime - this.startTime;
        }

        protected long getDurationOfSelf() {
            long duration = this.getDuration();
            if (duration < 0L) {
                return -1L;
            }
            if (this.subEntries.isEmpty()) {
                return duration;
            }
            for (int i = 0; i < this.subEntries.size(); ++i) {
                Entry subEntry = this.subEntries.get(i);
                duration -= subEntry.getDuration();
            }
            if (duration < 0L) {
                return -1L;
            }
            return duration;
        }

        protected double getPecentage() {
            double parentDuration = 0.0;
            double duration = this.getDuration();
            if (this.parent != null && this.parent.isReleased()) {
                parentDuration = this.parent.getDuration();
            }
            if (duration > 0.0 && parentDuration > 0.0) {
                return duration / parentDuration;
            }
            return 0.0;
        }

        protected double getPecentageOfAll() {
            double firstDuration = 0.0;
            double duration = this.getDuration();
            if (this.root != null && this.root.isReleased()) {
                firstDuration = this.root.getDuration();
            }
            if (duration > 0.0 && firstDuration > 0.0) {
                return duration / firstDuration;
            }
            return 0.0;
        }

        protected List<Entry> getSubEntries() {
            return Collections.unmodifiableList(this.subEntries);
        }

        protected void release() {
            this.endTime = System.currentTimeMillis();
        }

        protected boolean isReleased() {
            return this.endTime > 0L;
        }

        protected void enterSubEntry(String message) {
            Entry subEntry = new Entry(this, message);
            this.subEntries.add(subEntry);
        }

        protected Entry getUnreleasedEntry() {
            Entry subEntry = null;
            if (!this.subEntries.isEmpty() && (subEntry = this.subEntries.get(this.subEntries.size() - 1)).isReleased()) {
                subEntry = null;
            }
            return subEntry;
        }

        public String toString() {
            return this.toString("", "");
        }

        protected String toString(String prefix1, String prefix2) {
            StringBuffer buffer = new StringBuffer();
            this.toString(buffer, prefix1, prefix2);
            return buffer.toString();
        }

        protected void toString(StringBuffer buffer, String prefix1, String prefix2) {
            buffer.append(prefix1);
            String message = this.getMessage();
            long startTime = this.getStartTime();
            long duration = this.getDuration();
            long durationOfSelf = this.getDurationOfSelf();
            double percent = this.getPecentage();
            double percentOfAll = this.getPecentageOfAll();
            Object[] params = new Object[]{message, new Long(startTime), new Long(duration), new Long(durationOfSelf), new Double(percent), new Double(percentOfAll)};
            StringBuffer pattern = new StringBuffer("{1,number} ");
            if (this.isReleased()) {
                pattern.append("[{2,number}ms");
                if (durationOfSelf > 0L && durationOfSelf != duration) {
                    pattern.append(" ({3,number}ms)");
                }
                if (percent > 0.0) {
                    pattern.append(", {4,number,##%}");
                }
                if (percentOfAll > 0.0) {
                    pattern.append(", {5,number,##%}");
                }
                pattern.append("]");
            } else {
                pattern.append("[UNRELEASED]");
            }
            if (message != null) {
                pattern.append(" - {0}");
            }
            buffer.append(MessageFormat.format(pattern.toString(), params));
            for (int i = 0; i < this.subEntries.size(); ++i) {
                Entry subEntry = this.subEntries.get(i);
                buffer.append('\n');
                if (i == this.subEntries.size() - 1) {
                    subEntry.toString(buffer, prefix2 + "`---", prefix2 + "    ");
                    continue;
                }
                if (i == 0) {
                    subEntry.toString(buffer, prefix2 + "+---", prefix2 + "|   ");
                    continue;
                }
                subEntry.toString(buffer, prefix2 + "+---", prefix2 + "|   ");
            }
        }

        protected Entry deepClone() {
            Entry thisCopy = new Entry(this.parent, this.message, this.startTime, this.endTime);
            for (Entry child : this.subEntries) {
                thisCopy.subEntries.add(child.deepClone());
            }
            return thisCopy;
        }
    }
}

