/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class TrConcurrentHashMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    private static final long serialVersionUID = 5279156534327467864L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    final Entry<K, V>[] table;
    transient ReentrantLock[] locks;
    final AtomicInteger size = new AtomicInteger();
    transient KeySet keySet;
    transient Values values;
    transient EntrySet entrySet;

    private void init() {
        this.keySet = new KeySet();
        this.values = new Values();
        this.entrySet = new EntrySet();
        this.locks = new ReentrantLock[this.table.length];
        for (int i = 0; i < this.table.length; ++i) {
            this.locks[i] = new ReentrantLock();
        }
    }

    public TrConcurrentHashMap(int initialCapacity) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.table = new Entry[capacity];
        this.init();
    }

    public TrConcurrentHashMap() {
        this(16);
    }

    public TrConcurrentHashMap(Map<? extends K, ? extends V> m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 16));
        this.putAll(m);
    }

    static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0;
    }

    @Override
    public V get(Object key) {
        int hash = TrConcurrentHashMap.hash(key.hashCode());
        Entry<K, V> e = this.table[TrConcurrentHashMap.indexFor(hash, this.table.length)];
        while (e != null && (e.hash != hash || e.key != key && !e.key.equals(key))) {
            e = e.next;
        }
        return null != e ? (V)e.value : null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (0 == this.size()) {
            return false;
        }
        for (int i = 0; i < this.table.length; ++i) {
            Entry<K, V> e = this.table[i];
            while (e != null) {
                Object v = e.value;
                while (v == null) {
                    v = e.value;
                }
                if (value.equals(v)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    @Override
    public V put(K key, V value) {
        return this.put0(key, value, false);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.put0(key, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V put0(K key, V value, boolean onlyIfAbsent) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = TrConcurrentHashMap.hash(key.hashCode());
        int binIdx = TrConcurrentHashMap.indexFor(hash, this.table.length);
        ReentrantLock lock = this.locks[binIdx];
        lock.lock();
        try {
            V oldValue;
            Entry<K, V> head;
            Entry<K, V> node = head = this.table[binIdx];
            while (node != null && (hash != node.hash || key != node.key && !key.equals(node.key))) {
                node = node.next;
            }
            if (null == node) {
                oldValue = null;
                this.table[binIdx] = new Entry<K, V>(hash, key, value, head);
                this.size.incrementAndGet();
            } else {
                oldValue = node.value;
                if (!onlyIfAbsent) {
                    node.value = value;
                }
            }
            V v = oldValue;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (null == oldValue || null == newValue) {
            throw new NullPointerException();
        }
        return this.replace0(key, oldValue, newValue) != null;
    }

    @Override
    public V replace(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return this.replace0(key, null, value);
    }

    private V replace0(K key, V expectValue, V newValue) {
        Entry<K, V> head;
        int hash = TrConcurrentHashMap.hash(key.hashCode());
        int binIdx = TrConcurrentHashMap.indexFor(hash, this.table.length);
        Entry<K, V> node = head = this.table[binIdx];
        while (node != null && (hash != node.hash || key != node.key && !key.equals(node.key) || null != expectValue && !expectValue.equals(node.value))) {
            node = node.next;
        }
        V oldValue = null;
        if (null != node) {
            oldValue = node.value;
            node.value = newValue;
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        return this.remove0(key, null);
    }

    @Override
    public boolean remove(Object key, Object expectValue) {
        if (null == expectValue) {
            return false;
        }
        return this.remove0(key, expectValue) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V remove0(Object key, Object expectValue) {
        int hash = TrConcurrentHashMap.hash(key.hashCode());
        int binIdx = TrConcurrentHashMap.indexFor(hash, this.table.length);
        ReentrantLock lock = this.locks[binIdx];
        Entry<K, V> head = this.table[binIdx];
        lock.lock();
        try {
            Entry<K, V> node = head;
            while (node != null && (node.hash != hash || node.key != key && !key.equals(node.key) || null != expectValue && !expectValue.equals(node.value))) {
                node = node.next;
            }
            if (null != node) {
                Entry newBin = node.next;
                Entry<K, V> e = head;
                while (e != node) {
                    newBin = new Entry(e.hash, e.key, e.value, newBin);
                    e = e.next;
                }
                this.table[binIdx] = newBin;
                this.size.decrementAndGet();
            }
            V v = null != node ? (V)node.value : null;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void clear() {
        for (ReentrantLock lock : this.locks) {
            lock.lock();
        }
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = null;
        }
        this.size.set(0);
        for (ReentrantLock lock : this.locks) {
            lock.unlock();
        }
    }

    @Override
    public Set<K> keySet() {
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        for (ReentrantLock lock : this.locks) {
            lock.lock();
        }
        try {
            s.defaultWriteObject();
        }
        finally {
            for (ReentrantLock lock : this.locks) {
                lock.unlock();
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object v = TrConcurrentHashMap.this.get(e.getKey());
            return v != null && v.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return TrConcurrentHashMap.this.remove(e.getKey(), e.getValue());
        }

        @Override
        public int size() {
            return TrConcurrentHashMap.this.size();
        }

        @Override
        public void clear() {
            TrConcurrentHashMap.this.clear();
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return TrConcurrentHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return TrConcurrentHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            TrConcurrentHashMap.this.clear();
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return TrConcurrentHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return TrConcurrentHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return TrConcurrentHashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            TrConcurrentHashMap.this.clear();
        }
    }

    private final class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private final class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().key;
        }
    }

    private final class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator<E>
    implements Iterator<E> {
        Entry<K, V> nextEntry;
        Entry<K, V> lastReturned;
        int nextBinIdx;

        HashIterator() {
            this.advance();
        }

        private void advance() {
            if (null != this.nextEntry && null != (this.nextEntry = this.nextEntry.next)) {
                return;
            }
            while (this.nextBinIdx < TrConcurrentHashMap.this.table.length && (this.nextEntry = TrConcurrentHashMap.this.table[this.nextBinIdx++]) == null) {
            }
        }

        @Override
        public final boolean hasNext() {
            return this.nextEntry != null;
        }

        final Entry<K, V> nextEntry() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            TrConcurrentHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }

    static class Entry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final K key;
        final int hash;
        volatile V value;
        final Entry<K, V> next;

        Entry(int h, K k, V v, Entry<K, V> n) {
            this.value = v;
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Object v2;
            V v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

